/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.ListArbitrary;
import net.jqwik.engine.properties.FeatureExtractor;
import net.jqwik.engine.properties.arbitraries.MultivalueArbitraryBase;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableList;

public class DefaultListArbitrary<T>
extends MultivalueArbitraryBase<T, List<T>>
implements ListArbitrary<T> {
    public DefaultListArbitrary(Arbitrary<T> elementArbitrary) {
        super(elementArbitrary);
    }

    @Override
    protected Iterable<T> toIterable(List<T> streamable) {
        return streamable;
    }

    public RandomGenerator<List<T>> generator(int genSize) {
        return this.createListGenerator(genSize, false);
    }

    public RandomGenerator<List<T>> generatorWithEmbeddedEdgeCases(int genSize) {
        return this.createListGenerator(genSize, true);
    }

    public Optional<ExhaustiveGenerator<List<T>>> exhaustive(long maxNumberOfSamples) {
        return ExhaustiveGenerators.list(this.elementArbitrary, this.minSize, this.maxSize(), this.uniquenessExtractors, maxNumberOfSamples);
    }

    public EdgeCases<List<T>> edgeCases(int maxEdgeCases) {
        return this.edgeCases((elements, minSize1) -> new ShrinkableList(elements, (int)minSize1, this.maxSize(), this.uniquenessExtractors, this.elementArbitrary), maxEdgeCases);
    }

    public ListArbitrary<T> ofMaxSize(int maxSize) {
        return (ListArbitrary)super.ofMaxSize(maxSize);
    }

    public ListArbitrary<T> ofMinSize(int minSize) {
        return (ListArbitrary)super.ofMinSize(minSize);
    }

    public ListArbitrary<T> withSizeDistribution(RandomDistribution distribution) {
        return (ListArbitrary)super.withSizeDistribution(distribution);
    }

    public <U> Arbitrary<List<U>> mapEach(BiFunction<? super List<? extends T>, ? super T, ? extends U> mapper) {
        return this.map(elements -> elements.stream().map(e -> mapper.apply((Object)elements, (Object)e)).collect(Collectors.toList()));
    }

    public <U> Arbitrary<List<U>> flatMapEach(BiFunction<? super List<? extends T>, ? super T, ? extends Arbitrary<U>> flatMapper) {
        return this.flatMap(elements -> {
            List arbitraries = elements.stream().map(e -> (Arbitrary)flatMapper.apply((Object)elements, (Object)e)).collect(Collectors.toList());
            return Combinators.combine(arbitraries).as(ArrayList::new);
        });
    }

    public ListArbitrary<T> uniqueElements(Function<? super T, ?> by) {
        FeatureExtractor featureExtractor = by::apply;
        return (ListArbitrary)super.uniqueElements(featureExtractor);
    }

    public ListArbitrary<T> uniqueElements() {
        return (ListArbitrary)super.uniqueElements();
    }
}

