/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;

public class GenericEdgeCasesConfiguration<T>
implements EdgeCases.Config<T> {
    private boolean none;
    private final List<Predicate<? super T>> filters = new ArrayList<Predicate<? super T>>();
    private final List<T> additionalEdgeCases = new ArrayList<T>();

    public EdgeCases.Config<T> none() {
        this.none = true;
        return this;
    }

    public EdgeCases.Config<T> filter(Predicate<? super T> filter) {
        this.filters.add(filter);
        return this;
    }

    @SafeVarargs
    public final EdgeCases.Config<T> add(T ... edgeCases) {
        for (T edgeCase : edgeCases) {
            this.checkEdgeCaseIsValid(edgeCase);
            this.additionalEdgeCases.add(edgeCase);
        }
        return this;
    }

    protected void checkEdgeCaseIsValid(T edgeCase) {
    }

    @SafeVarargs
    public final EdgeCases.Config<T> includeOnly(T ... includedValues) {
        List<T> values = Arrays.asList(includedValues);
        return this.filter(values::contains);
    }

    public EdgeCases<T> configure(Consumer<? super EdgeCases.Config<T>> configurator, Function<? super Integer, ? extends EdgeCases<T>> edgeCasesCreator, int maxEdgeCases) {
        configurator.accept(this);
        EdgeCases<? super Integer> configuredEdgeCases = this.none ? EdgeCases.none() : (this.filters.isEmpty() ? edgeCasesCreator.apply(maxEdgeCases) : edgeCasesCreator.apply(Integer.MAX_VALUE));
        List suppliers = configuredEdgeCases.suppliers();
        for (Predicate<? super T> predicate : new ArrayList<Predicate<T>>(this.filters)) {
            suppliers = suppliers.stream().filter(s -> filter.test(((Shrinkable)s.get()).value())).collect(Collectors.toList());
        }
        for (Predicate<Object> predicate : this.additionalEdgeCases) {
            suppliers.add(() -> this.createShrinkable(additionalEdgeCase));
        }
        return EdgeCasesSupport.fromSuppliers(suppliers);
    }

    protected Shrinkable<T> createShrinkable(T additionalEdgeCase) {
        return Shrinkable.unshrinkable(additionalEdgeCase);
    }
}

