/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.TooManyFilterMissesException;
import net.jqwik.engine.properties.shrinking.FilteredShrinkable;

public class FilteredGenerator<T>
implements RandomGenerator<T> {
    private final RandomGenerator<T> toFilter;
    private final Predicate<? super T> filterPredicate;
    private int maxMisses;

    public FilteredGenerator(RandomGenerator<T> toFilter, Predicate<? super T> filterPredicate, int maxMisses) {
        this.toFilter = toFilter;
        this.filterPredicate = filterPredicate;
        this.maxMisses = maxMisses;
    }

    public Shrinkable<T> next(Random random) {
        return this.nextUntilAccepted(random, arg_0 -> this.toFilter.next(arg_0));
    }

    public String toString() {
        return String.format("Filtering [%s]", this.toFilter);
    }

    private Shrinkable<T> nextUntilAccepted(Random random, Function<Random, Shrinkable<T>> fetchShrinkable) {
        for (int i = 0; i < this.maxMisses; ++i) {
            Shrinkable<T> value = fetchShrinkable.apply(random);
            if (!this.filterPredicate.test(value.value())) continue;
            return new FilteredShrinkable<T>(value, this.filterPredicate);
        }
        String message = String.format("%s missed more than %s times.", this.toString(), this.maxMisses);
        throw new TooManyFilterMissesException(message);
    }
}

