/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.Tuple;
import net.jqwik.api.lifecycle.FalsifiedSample;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.engine.properties.shrinking.AbstractSampleShrinker;
import net.jqwik.engine.support.Combinatorics;

class ShrinkAndGrowShrinker
extends AbstractSampleShrinker {
    public ShrinkAndGrowShrinker(Map<List<Object>, TryExecutionResult> falsificationCache) {
        super(falsificationCache);
    }

    @Override
    public FalsifiedSample shrink(Falsifier<List<Object>> falsifier, FalsifiedSample sample, Consumer<FalsifiedSample> sampleShrunkConsumer, Consumer<FalsifiedSample> shrinkAttemptConsumer) {
        FalsifiedSample current = sample;
        List allPairs = Combinatorics.distinctPairs(sample.shrinkables().size()).collect(Collectors.toList());
        for (Tuple.Tuple2 pair : allPairs) {
            current = this.shrinkAndGrow(falsifier, current, sampleShrunkConsumer, shrinkAttemptConsumer, (Integer)pair.get1(), (Integer)pair.get2());
        }
        return current;
    }

    private FalsifiedSample shrinkAndGrow(Falsifier<List<Object>> falsifier, FalsifiedSample sample, Consumer<FalsifiedSample> sampleShrunkConsumer, Consumer<FalsifiedSample> shrinkAttemptConsumer, int index1, int index2) {
        Function<List<Shrinkable<Object>>, Stream<List<Shrinkable<Object>>>> shrinker = shrinkables -> {
            Shrinkable before = (Shrinkable)shrinkables.get(index1);
            Stream afterStream = before.shrink();
            return afterStream.flatMap(after -> {
                Optional optionalShrink2 = ((Shrinkable)shrinkables.get(index2)).grow(before, after);
                if (optionalShrink2.isPresent()) {
                    ArrayList<Shrinkable> newShrinkables = new ArrayList<Shrinkable>(sample.shrinkables());
                    newShrinkables.set(index1, (Shrinkable)after);
                    newShrinkables.set(index2, (Shrinkable)optionalShrink2.get());
                    return Stream.of(newShrinkables);
                }
                return Stream.empty();
            });
        };
        return this.shrink(falsifier, sample, sampleShrunkConsumer, shrinkAttemptConsumer, shrinker);
    }
}

