/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.FeatureExtractor;
import net.jqwik.engine.properties.shrinking.ShrinkableContainer;
import net.jqwik.engine.support.JqwikStreamSupport;

public class ShrinkableString
extends ShrinkableContainer<String, Character> {
    public static final Set<FeatureExtractor<Character>> UNIQUE_CHARS_EXTRACTOR = Collections.singleton(FeatureExtractor.identity());

    public ShrinkableString(List<? extends Shrinkable<Character>> elements, int minSize, int maxSize, Arbitrary<Character> characterArbitrary, boolean uniqueChars) {
        this(elements, minSize, maxSize, (Collection<? extends FeatureExtractor<Character>>)ShrinkableString.uniquenessExtractors(uniqueChars), characterArbitrary);
    }

    private ShrinkableString(List<? extends Shrinkable<Character>> elements, int minSize, int maxSize, Collection<? extends FeatureExtractor<Character>> uniquenessExtractors, Arbitrary<Character> characterArbitrary) {
        super(elements, minSize, maxSize, uniquenessExtractors, characterArbitrary);
    }

    private static Collection<FeatureExtractor<Character>> uniquenessExtractors(boolean uniqueChars) {
        return uniqueChars ? UNIQUE_CHARS_EXTRACTOR : Collections.emptySet();
    }

    @Override
    String createValue(List<? extends Shrinkable<Character>> shrinkables) {
        StringBuilder builder = new StringBuilder(shrinkables.size());
        for (Shrinkable<Character> shrinkable : shrinkables) {
            builder.appendCodePoint(((Character)shrinkable.value()).charValue());
        }
        return builder.toString();
    }

    @Override
    Shrinkable<String> createShrinkable(List<? extends Shrinkable<Character>> shrunkElements) {
        return new ShrinkableString(shrunkElements, this.minSize, this.maxSize, this.uniquenessExtractors, (Arbitrary<Character>)this.elementArbitrary);
    }

    @Override
    public Stream<Shrinkable<String>> shrink() {
        if (this.elements.size() > 100) {
            return JqwikStreamSupport.concat(this.shrinkSizeAggressively(), this.shrinkSizeOfList(), this.shrinkElementsOneAfterTheOther(100));
        }
        return JqwikStreamSupport.concat(this.shrinkSizeOfList(), this.shrinkElementsOneAfterTheOther(0), this.shrinkPairsOfElements(), this.sortElements());
    }
}

