/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.Tuple;
import net.jqwik.engine.support.Combinatorics;
import net.jqwik.engine.support.JqwikStreamSupport;

class ShrinkingCommons {
    ShrinkingCommons() {
    }

    static <C, E> Stream<Shrinkable<C>> shrinkPairsOfElements(List<? extends Shrinkable<E>> elements, ContainerCreator<C, E> createContainer) {
        return Combinatorics.distinctPairs(elements.size()).flatMap(pair -> JqwikStreamSupport.zip(((Shrinkable)elements.get((Integer)pair.get1())).shrink(), ((Shrinkable)elements.get((Integer)pair.get2())).shrink(), (s1, s2) -> {
            ArrayList<Shrinkable> newElements = new ArrayList<Shrinkable>(elements);
            newElements.set((Integer)pair.get1(), (Shrinkable)s1);
            newElements.set((Integer)pair.get2(), (Shrinkable)s2);
            return (Shrinkable)createContainer.apply(newElements);
        }));
    }

    static <C, E> Stream<Shrinkable<C>> sortElements(List<? extends Shrinkable<E>> elements, ContainerCreator<C, E> createContainer) {
        ArrayList<Shrinkable<Shrinkable>> sortedElements = new ArrayList<Shrinkable<Shrinkable>>(elements);
        sortedElements.sort(Comparator.comparing(Shrinkable::distance));
        if (elements.equals(sortedElements)) {
            return Stream.empty();
        }
        return JqwikStreamSupport.concat(ShrinkingCommons.fullSort(sortedElements, createContainer), ShrinkingCommons.pairwiseSort(elements, createContainer));
    }

    private static <C, E> Stream<Shrinkable<C>> fullSort(List<? extends Shrinkable<E>> sortedElements, ContainerCreator<C, E> createContainer) {
        return Stream.of((Shrinkable)createContainer.apply(sortedElements));
    }

    private static <C, E> Stream<Shrinkable<C>> pairwiseSort(List<? extends Shrinkable<E>> elements, ContainerCreator<C, E> createContainer) {
        return Combinatorics.distinctPairs(elements.size()).map(pair -> {
            int firstIndex = Math.min((Integer)pair.get1(), (Integer)pair.get2());
            int secondIndex = Math.max((Integer)pair.get1(), (Integer)pair.get2());
            Shrinkable first = (Shrinkable)elements.get(firstIndex);
            Shrinkable second = (Shrinkable)elements.get(secondIndex);
            return Tuple.of((Object)firstIndex, (Object)first, (Object)secondIndex, (Object)second);
        }).filter(quadruple -> ((Shrinkable)quadruple.get2()).compareTo((Shrinkable)quadruple.get4()) > 0).map(quadruple -> {
            ArrayList<Shrinkable> pairSwap = new ArrayList<Shrinkable>(elements);
            pairSwap.set((Integer)quadruple.get1(), (Shrinkable)quadruple.get4());
            pairSwap.set((Integer)quadruple.get3(), (Shrinkable)quadruple.get2());
            return (Shrinkable)createContainer.apply(pairSwap);
        });
    }

    @FunctionalInterface
    static interface ContainerCreator<C, E>
    extends Function<List<? extends Shrinkable<E>>, Shrinkable<C>> {
    }
}

