/*
 * Decompiled with CFR 0.152.
 */
package net.nullschool.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.crypto.Mac;
import net.nullschool.util.RdRandEngine;

final class EngineTools {
    private static final int MAX_UNPACK_RETRIES = 10;
    private static final List<String> X86 = Arrays.asList("x86", "i386");
    private static final List<String> X64 = Arrays.asList("x86_64", "amd64");
    private static final Random rand = new Random();
    private static final Path tmpdir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve("1bd31d66-eda2-4395-a2a7-510bd581e3ab");
    private static final String osname = System.getProperty("os.name", "unknown");
    private static final String osarch = System.getProperty("os.arch", "unknown");

    private EngineTools() {
        throw new AssertionError();
    }

    private static String packageOf(Class<?> clazz) {
        return clazz.getName().substring(0, clazz.getName().lastIndexOf(46) + 1);
    }

    private static void deleteIfExists(Path dir, String glob) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, glob);){
            for (Path p : stream) {
                Files.deleteIfExists(p);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static Path unpackResource(Class<?> clazz, String name, Path target) throws IOException {
        try (InputStream in = clazz.getResourceAsStream(name);){
            if (in != null) {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                Files.copy(in, target, StandardCopyOption.REPLACE_EXISTING);
                Path path = target;
                return path;
            }
            Path path = null;
            return path;
        }
    }

    static Path unpackTemporaryResource(Class<?> clazz, String name) throws IOException {
        String prefix = (name.startsWith("/") ? name.substring(1) : EngineTools.packageOf(clazz) + name).replace('/', '.') + '_';
        EngineTools.deleteIfExists(tmpdir, prefix + "*");
        Path target = tmpdir.resolve(prefix + Math.abs(rand.nextLong()));
        Path result = EngineTools.unpackResource(clazz, name, target);
        if (result != null) {
            result.toFile().deleteOnExit();
        }
        return result;
    }

    static String deriveRdRandLibraryName() {
        String arch;
        String path = "unknown/";
        String extension = ".unknown";
        String string = X86.contains(osarch) ? "-x86" : (arch = X64.contains(osarch) ? "-x64" : "-unknown");
        if (osname.startsWith("Win")) {
            path = "windows/";
            extension = ".dll";
        } else if (osname.startsWith("Mac")) {
            path = "macosx/";
            extension = ".dylib";
        } else if (osname.startsWith("Lin")) {
            path = "linux/";
            extension = ".so";
        } else if (osname.startsWith("Sun")) {
            path = "solaris/";
            extension = ".so";
        }
        return path + "drnglib" + arch + extension;
    }

    static void loadRdRandNativeLibrary() throws IOException {
        Path p;
        String library = EngineTools.deriveRdRandLibraryName();
        if (RdRandEngine.class.getResource(library) == null) {
            throw new IllegalArgumentException(String.format("Cannot find resource '%s' for %s %s architecture.", library, osname, osarch));
        }
        for (int i = 0; i < 10 && (p = EngineTools.unpackTemporaryResource(RdRandEngine.class, library)) != null && Files.exists(p, new LinkOption[0]); ++i) {
            try {
                System.load(p.toString());
                return;
            }
            catch (UnsatisfiedLinkError e) {
                if (!Files.exists(p, new LinkOption[0])) continue;
                throw e;
            }
        }
        throw new UnsatisfiedLinkError("Failed to load " + osname);
    }

    static byte[] hashSHA256(Key key, byte[] data) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(key);
            return mac.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

