/*
 * Decompiled with CFR 0.152.
 */
package net.nullschool.util;

import java.io.IOException;
import javax.crypto.spec.SecretKeySpec;
import net.nullschool.util.DigitalRandomSpi;
import net.nullschool.util.EngineTools;

final class RdRandEngine
extends DigitalRandomSpi {
    private static volatile boolean isSupported;
    private static volatile boolean isLinked;
    private static final Object lock;
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void link() throws IOException {
        Object object = lock;
        synchronized (object) {
            if (!isLinked) {
                EngineTools.loadRdRandNativeLibrary();
                isLinked = true;
            }
        }
    }

    private static native boolean isRdRandSupported();

    static boolean linkAndCheckRdRandSupported() {
        if (isSupported) {
            return true;
        }
        try {
            RdRandEngine.link();
            isSupported = RdRandEngine.isRdRandSupported();
            return isSupported;
        }
        catch (Throwable t) {
            throw new UnsupportedOperationException("Random number generation using rdrand is not supported because engine initialization failed.", t);
        }
    }

    RdRandEngine() throws UnsupportedOperationException {
        if (!RdRandEngine.linkAndCheckRdRandSupported()) {
            throw new UnsupportedOperationException("Random number generation using rdrand is not supported by this CPU.");
        }
    }

    @Override
    protected void engineSetSeed(byte[] seed) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected native int engineNextInt();

    @Override
    protected native long engineNextLong();

    @Override
    protected native void engineNextBytes(byte[] var1);

    private byte[] nextBytes(byte[] bytes) {
        this.engineNextBytes(bytes);
        return bytes;
    }

    @Override
    protected byte[] engineGenerateSeed(int numBytes) {
        int size;
        byte[] seed = new byte[numBytes];
        byte[] sample = new byte[8192];
        SecretKeySpec key = new SecretKeySpec(this.nextBytes(new byte[16]), "None");
        for (int written = 0; written < seed.length; written += size) {
            byte[] hash = EngineTools.hashSHA256(key, this.nextBytes(sample));
            size = Math.min(hash.length, seed.length - written);
            System.arraycopy(hash, 0, seed, written, size);
        }
        return seed;
    }

    static {
        lock = new Object();
    }
}

