/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ChronicleQueueSink;
import net.openhft.chronicle.ChronicleQueueSource;
import net.openhft.chronicle.IndexedChronicle;
import net.openhft.chronicle.MappingFunction;
import net.openhft.chronicle.MappingProvider;
import net.openhft.chronicle.RemoteChronicleQueueAppender;
import net.openhft.chronicle.RemoteChronicleQueueTailer;
import net.openhft.chronicle.VanillaChronicle;
import net.openhft.chronicle.tcp.AddressProvider;
import net.openhft.chronicle.tcp.AddressProviders;
import net.openhft.chronicle.tcp.SinkTcp;
import net.openhft.chronicle.tcp.SinkTcpAcceptor;
import net.openhft.chronicle.tcp.SinkTcpInitiator;
import net.openhft.chronicle.tcp.SourceTcp;
import net.openhft.chronicle.tcp.SourceTcpAcceptor;
import net.openhft.chronicle.tcp.SourceTcpInitiator;
import net.openhft.chronicle.tcp.TcpConnectionHandler;
import net.openhft.chronicle.tcp.TcpConnectionListener;
import net.openhft.lang.Jvm;
import net.openhft.lang.Maths;
import net.openhft.lang.io.FileLifecycleListener;
import net.openhft.lang.model.constraints.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChronicleQueueBuilder
implements Cloneable {
    public static IndexedChronicleQueueBuilder indexed(File path) {
        return new IndexedChronicleQueueBuilder(path);
    }

    public static IndexedChronicleQueueBuilder indexed(String path) {
        return ChronicleQueueBuilder.indexed(new File(path));
    }

    public static IndexedChronicleQueueBuilder indexed(String parent, String child) {
        return ChronicleQueueBuilder.indexed(new File(parent, child));
    }

    public static IndexedChronicleQueueBuilder indexed(File parent, String child) {
        return ChronicleQueueBuilder.indexed(new File(parent, child));
    }

    public static VanillaChronicleQueueBuilder vanilla(File path) {
        return new VanillaChronicleQueueBuilder(path);
    }

    public static VanillaChronicleQueueBuilder vanilla(String path) {
        return ChronicleQueueBuilder.vanilla(new File(path));
    }

    public static VanillaChronicleQueueBuilder vanilla(String parent, String child) {
        return ChronicleQueueBuilder.vanilla(new File(parent, child));
    }

    public static VanillaChronicleQueueBuilder vanilla(File parent, String child) {
        return ChronicleQueueBuilder.vanilla(new File(parent, child));
    }

    public static ReplicaChronicleQueueBuilder sink(Chronicle chronicle) {
        return new SinkChronicleQueueBuilder(chronicle);
    }

    public static ReplicaChronicleQueueBuilder source(Chronicle chronicle) {
        return new SourceChronicleQueueBuilder(chronicle);
    }

    public static ReplicaChronicleQueueBuilder remoteAppender() {
        return new RemoteChronicleQueueAppenderBuilder();
    }

    public static ReplicaChronicleQueueBuilder remoteTailer() {
        return new RemoteChronicleQueueTailerBuilder();
    }

    public abstract Chronicle build() throws IOException;

    @NotNull
    public ChronicleQueueBuilder clone() throws CloneNotSupportedException {
        return (ChronicleQueueBuilder)super.clone();
    }

    private static final class RemoteChronicleQueueTailerBuilder
    extends ReplicaChronicleQueueBuilder {
        private RemoteChronicleQueueTailerBuilder() {
            super(null, null);
        }

        @Override
        public Chronicle doBuild() {
            SinkTcp cnx;
            if (this.bindAddress() != null && this.connectAddress() == null) {
                cnx = new SinkTcpAcceptor(this);
            } else if (this.connectAddress() != null) {
                cnx = new SinkTcpInitiator(this);
            } else {
                throw new IllegalArgumentException("BindAddress and ConnectAddress are not set");
            }
            return new RemoteChronicleQueueTailer(this, cnx);
        }

        @Override
        @NotNull
        public RemoteChronicleQueueTailerBuilder clone() {
            return (RemoteChronicleQueueTailerBuilder)super.clone();
        }
    }

    private static final class RemoteChronicleQueueAppenderBuilder
    extends ReplicaChronicleQueueBuilder {
        private RemoteChronicleQueueAppenderBuilder() {
            super(null, null);
        }

        @Override
        public Chronicle doBuild() {
            SinkTcp cnx;
            if (this.bindAddress() != null && this.connectAddress() == null) {
                cnx = new SinkTcpAcceptor(this);
            } else if (this.connectAddress() != null) {
                cnx = new SinkTcpInitiator(this);
            } else {
                throw new IllegalArgumentException("BindAddress and ConnectAddress are not set");
            }
            return new RemoteChronicleQueueAppender(this, cnx);
        }

        @Override
        @NotNull
        public RemoteChronicleQueueAppenderBuilder clone() {
            return (RemoteChronicleQueueAppenderBuilder)super.clone();
        }
    }

    private static class SourceChronicleQueueBuilder
    extends ReplicaChronicleQueueBuilder {
        private SourceChronicleQueueBuilder(@NotNull ChronicleQueueBuilder builder) {
            super(null, builder);
        }

        private SourceChronicleQueueBuilder(@NotNull Chronicle chronicle) {
            super(chronicle, null);
        }

        @Override
        public Chronicle doBuild() {
            SourceTcp cnx;
            if (this.bindAddress() != null && this.connectAddress() == null) {
                cnx = new SourceTcpAcceptor(this);
            } else if (this.connectAddress() != null) {
                cnx = new SourceTcpInitiator(this);
            } else {
                throw new IllegalArgumentException("BindAddress and ConnectAddress are not set");
            }
            return new ChronicleQueueSource(this, cnx);
        }

        @Override
        @NotNull
        public SourceChronicleQueueBuilder clone() {
            return (SourceChronicleQueueBuilder)super.clone();
        }
    }

    private static class SinkChronicleQueueBuilder
    extends ReplicaChronicleQueueBuilder {
        private SinkChronicleQueueBuilder() {
            super(null, null);
        }

        private SinkChronicleQueueBuilder(@NotNull ChronicleQueueBuilder builder) {
            super(null, builder);
        }

        private SinkChronicleQueueBuilder(@NotNull Chronicle chronicle) {
            super(chronicle, null);
        }

        @Override
        public Chronicle doBuild() {
            SinkTcp cnx;
            if (this.bindAddress() != null && this.connectAddress() == null) {
                cnx = new SinkTcpAcceptor(this);
            } else if (this.connectAddress() != null) {
                cnx = new SinkTcpInitiator(this);
            } else {
                throw new IllegalArgumentException("BindAddress and ConnectAddress are not set");
            }
            return new ChronicleQueueSink(this, cnx);
        }

        @Override
        @NotNull
        public SinkChronicleQueueBuilder clone() {
            return (SinkChronicleQueueBuilder)super.clone();
        }
    }

    public static abstract class ReplicaChronicleQueueBuilder
    extends ChronicleQueueBuilder
    implements MappingProvider<ReplicaChronicleQueueBuilder> {
        public static final int DEFAULT_SOCKET_BUFFER_SIZE = 262144;
        public static final TcpConnectionListener CONNECTION_LISTENER = new TcpConnectionHandler();
        private final ChronicleQueueBuilder builder;
        private Chronicle chronicle;
        private AddressProvider bindAddressProvider;
        private AddressProvider connectAddressProvider;
        private int reconnectionAttempts;
        private int reconnectionWarningThreshold;
        private long reconnectionInterval;
        private TimeUnit reconnectionIntervalUnit;
        private long selectTimeout;
        private TimeUnit selectTimeoutUnit;
        private int receiveBufferSize;
        private int sendBufferSize;
        private int minBufferSize;
        private boolean sharedChronicle;
        private long heartbeatInterval;
        private TimeUnit heartbeatIntervalUnit;
        private int maxExcerptsPerMessage;
        private int selectorSpinLoopCount;
        private int readSpinCount;
        private boolean appendRequireAck;
        private int acceptorMaxBacklog;
        private int acceptorDefaultThreads;
        private int acceptorMaxThreads;
        private long acceptorThreadPoolKeepAliveTime;
        private TimeUnit acceptorThreadPoolKeepAliveTimeUnit;
        private TcpConnectionListener connectionListener;
        private long busyPeriod;
        private TimeUnit busyPeriodTimeUnit;
        private long parkPeriod;
        private TimeUnit parkPeriodTimeUnit;
        @Nullable
        private MappingFunction mapping;

        private ReplicaChronicleQueueBuilder(Chronicle chronicle, ChronicleQueueBuilder builder) {
            this.builder = builder;
            this.chronicle = chronicle;
            this.bindAddressProvider = null;
            this.connectAddressProvider = null;
            this.reconnectionInterval = 500L;
            this.reconnectionIntervalUnit = TimeUnit.MILLISECONDS;
            this.reconnectionAttempts = 1;
            this.reconnectionWarningThreshold = 10;
            this.selectTimeout = 1000L;
            this.selectTimeoutUnit = TimeUnit.MILLISECONDS;
            this.heartbeatInterval = 2500L;
            this.heartbeatIntervalUnit = TimeUnit.MILLISECONDS;
            this.receiveBufferSize = 262144;
            this.sendBufferSize = 262144;
            this.minBufferSize = 262144;
            this.sharedChronicle = false;
            this.acceptorMaxBacklog = 50;
            this.acceptorDefaultThreads = 0;
            this.acceptorMaxThreads = Integer.MAX_VALUE;
            this.acceptorThreadPoolKeepAliveTime = 60L;
            this.acceptorThreadPoolKeepAliveTimeUnit = TimeUnit.SECONDS;
            this.maxExcerptsPerMessage = 128;
            this.selectorSpinLoopCount = 100000;
            this.readSpinCount = -1;
            this.connectionListener = CONNECTION_LISTENER;
            this.appendRequireAck = false;
            this.mapping = null;
            this.busyPeriod = TimeUnit.NANOSECONDS.convert(20L, TimeUnit.MICROSECONDS);
            this.busyPeriodTimeUnit = TimeUnit.NANOSECONDS;
            this.parkPeriod = TimeUnit.NANOSECONDS.convert(200L, TimeUnit.MICROSECONDS);
            this.parkPeriodTimeUnit = TimeUnit.NANOSECONDS;
        }

        public InetSocketAddress bindAddress() {
            return this.bindAddressProvider != null ? this.bindAddressProvider.get() : null;
        }

        public ReplicaChronicleQueueBuilder bindAddress(InetSocketAddress bindAddress) {
            this.bindAddressProvider = AddressProviders.single(bindAddress);
            return this;
        }

        public ReplicaChronicleQueueBuilder bindAddress(int port) {
            return this.bindAddress(new InetSocketAddress(port));
        }

        public ReplicaChronicleQueueBuilder bindAddress(String host, int port) {
            return this.bindAddress(new InetSocketAddress(host, port));
        }

        public AddressProvider bindAddressProvider() {
            return this.connectAddressProvider;
        }

        public ReplicaChronicleQueueBuilder bindAddressProvider(AddressProvider bindAddressProvider) {
            this.bindAddressProvider = bindAddressProvider;
            return this;
        }

        public InetSocketAddress connectAddress() {
            return this.connectAddressProvider != null ? this.connectAddressProvider.get() : null;
        }

        public ReplicaChronicleQueueBuilder connectAddress(InetSocketAddress connectAddress) {
            this.connectAddressProvider = AddressProviders.single(connectAddress);
            return this;
        }

        public AddressProvider connectAddressProvider() {
            return this.connectAddressProvider;
        }

        public ReplicaChronicleQueueBuilder connectAddressProvider(AddressProvider connectAddressprovider) {
            this.connectAddressProvider = connectAddressprovider;
            return this;
        }

        public ReplicaChronicleQueueBuilder connectAddress(String host, int port) {
            return this.connectAddress(new InetSocketAddress(host, port));
        }

        public long reconnectionreconnectionInterval() {
            return this.reconnectionInterval;
        }

        public ReplicaChronicleQueueBuilder reconnectionInterval(long reconnectTimeout) {
            this.reconnectionInterval = reconnectTimeout;
            return this;
        }

        public long reconnectionIntervalMillis() {
            return this.reconnectionIntervalUnit.toMillis(this.reconnectionInterval);
        }

        public ReplicaChronicleQueueBuilder reconnectionInterval(long reconnectionInterval, TimeUnit reconnectionIntervalUnit) {
            this.reconnectionInterval = reconnectionInterval;
            this.reconnectionIntervalUnit = reconnectionIntervalUnit;
            return this;
        }

        public TimeUnit reconnectionIntervalUnit() {
            return this.reconnectionIntervalUnit;
        }

        public ReplicaChronicleQueueBuilder reconnectionIntervalUnit(TimeUnit reconnectionInterval) {
            this.reconnectionIntervalUnit = reconnectionInterval;
            return this;
        }

        public int reconnectionAttempts() {
            return this.reconnectionAttempts;
        }

        public ReplicaChronicleQueueBuilder reconnectionAttempts(int reconnectionAttempts) {
            if (reconnectionAttempts < 0) {
                throw new IllegalArgumentException("ReconnectionAttempts must be greater or equals than 0");
            }
            this.reconnectionAttempts = reconnectionAttempts;
            return this;
        }

        public int reconnectionWarningThreshold() {
            return this.reconnectionWarningThreshold;
        }

        public ReplicaChronicleQueueBuilder reconnectionWarningThreshold(int reconnectionWarningThreshold) {
            if (reconnectionWarningThreshold < 0) {
                throw new IllegalArgumentException("ReconnectionWarningThreshold must be greater or equals than 0");
            }
            this.reconnectionWarningThreshold = reconnectionWarningThreshold;
            return this;
        }

        public long selectTimeout() {
            return this.selectTimeout;
        }

        public long selectTimeoutMillis() {
            return this.selectTimeoutUnit.toMillis(this.selectTimeout);
        }

        public ReplicaChronicleQueueBuilder selectTimeout(long selectTimeout, TimeUnit selectTimeoutUnit) {
            this.selectTimeout = selectTimeout;
            this.selectTimeoutUnit = selectTimeoutUnit;
            return this;
        }

        public TimeUnit selectTimeoutUnit() {
            return this.selectTimeoutUnit;
        }

        public ReplicaChronicleQueueBuilder heartbeatInterval(long heartbeatInterval, TimeUnit heartbeatIntervalUnit) {
            this.heartbeatInterval = heartbeatInterval;
            this.heartbeatIntervalUnit = heartbeatIntervalUnit;
            return this;
        }

        public long heartbeatInterval() {
            return this.heartbeatInterval;
        }

        public long heartbeatIntervalMillis() {
            return this.heartbeatIntervalUnit.toMillis(this.heartbeatInterval);
        }

        public TimeUnit heartbeatIntervalUnit() {
            return this.heartbeatIntervalUnit;
        }

        public int defaultSocketBufferSize() {
            return 262144;
        }

        public int receiveBufferSize() {
            return this.receiveBufferSize;
        }

        public ReplicaChronicleQueueBuilder receiveBufferSize(int receiveBufferSize) {
            this.receiveBufferSize = receiveBufferSize;
            return this;
        }

        public int sendBufferSize() {
            return this.sendBufferSize;
        }

        public ReplicaChronicleQueueBuilder sendBufferSize(int sendBufferSize) {
            this.sendBufferSize = sendBufferSize;
            return this;
        }

        public int minBufferSize() {
            return this.minBufferSize;
        }

        public ReplicaChronicleQueueBuilder minBufferSize(int minBufferSize) {
            if (!Maths.isPowerOf2((int)minBufferSize)) {
                throw new IllegalArgumentException("MinBufferSize must be a power of 2");
            }
            this.minBufferSize = minBufferSize;
            return this;
        }

        public int maxExcerptsPerMessage() {
            return this.maxExcerptsPerMessage;
        }

        public ReplicaChronicleQueueBuilder maxExcerptsPerMessage(int maxExcerptsPerMessage) {
            this.maxExcerptsPerMessage = maxExcerptsPerMessage;
            return this;
        }

        public boolean sharedChronicle() {
            return this.sharedChronicle;
        }

        public ReplicaChronicleQueueBuilder sharedChronicle(boolean sharedChronicle) {
            this.sharedChronicle = sharedChronicle;
            return this;
        }

        public ReplicaChronicleQueueBuilder acceptorMaxBacklog(int acceptorMaxBacklog) {
            this.acceptorMaxBacklog = acceptorMaxBacklog;
            return this;
        }

        public int acceptorMaxBacklog() {
            return this.acceptorMaxBacklog;
        }

        public ReplicaChronicleQueueBuilder acceptorDefaultThreads(int acceptorDefaultThreads) {
            this.acceptorDefaultThreads = acceptorDefaultThreads;
            return this;
        }

        public int acceptorDefaultThreads() {
            return this.acceptorDefaultThreads;
        }

        public ReplicaChronicleQueueBuilder acceptorMaxThreads(int acceptorMaxThreads) {
            this.acceptorMaxThreads = acceptorMaxThreads;
            return this;
        }

        public int acceptorMaxThreads() {
            return this.acceptorMaxThreads;
        }

        public ReplicaChronicleQueueBuilder acceptorThreadPoolkeepAlive(long acceptorThreadPoolKeepAliveTime, TimeUnit acceptorThreadPoolKeepAliveTimeUnit) {
            this.acceptorThreadPoolKeepAliveTime = acceptorThreadPoolKeepAliveTime;
            this.acceptorThreadPoolKeepAliveTimeUnit = acceptorThreadPoolKeepAliveTimeUnit;
            return this;
        }

        public long acceptorThreadPoolkeepAliveTime() {
            return this.acceptorThreadPoolKeepAliveTime;
        }

        public ReplicaChronicleQueueBuilder acceptorThreadPoolkeepAliveTime(long acceptorThreadPoolKeepAliveTime) {
            this.acceptorThreadPoolKeepAliveTime = acceptorThreadPoolKeepAliveTime;
            return this;
        }

        public TimeUnit acceptorThreadPoolkeepAliveTimeUnit() {
            return this.acceptorThreadPoolKeepAliveTimeUnit;
        }

        public ReplicaChronicleQueueBuilder acceptorThreadPoolkeepAliveTimeUnit(TimeUnit acceptorThreadPoolKeepAliveTimeUnit) {
            this.acceptorThreadPoolKeepAliveTimeUnit = acceptorThreadPoolKeepAliveTimeUnit;
            return this;
        }

        public long acceptorThreadPoolkeepAliveTimeMillis() {
            return this.acceptorThreadPoolKeepAliveTimeUnit.toMillis(this.acceptorThreadPoolKeepAliveTime);
        }

        public ReplicaChronicleQueueBuilder busyPeriod(long busyPeriod, TimeUnit busyPeriodTimeUnit) {
            this.busyPeriod = busyPeriod;
            this.busyPeriodTimeUnit = busyPeriodTimeUnit;
            return this;
        }

        public long busyPeriod() {
            return this.busyPeriod;
        }

        public ReplicaChronicleQueueBuilder busyPeriod(long busyPeriod) {
            this.busyPeriod = busyPeriod;
            return this;
        }

        public TimeUnit busyPeriodTimeUnit() {
            return this.busyPeriodTimeUnit;
        }

        public ReplicaChronicleQueueBuilder busyPeriodTimeUnit(TimeUnit busyPeriodTimeUnit) {
            this.busyPeriodTimeUnit = busyPeriodTimeUnit;
            return this;
        }

        public long busyPeriodTimeNanos() {
            return this.busyPeriodTimeUnit.toNanos(this.busyPeriod);
        }

        public ReplicaChronicleQueueBuilder parkPeriod(long parkPeriod, TimeUnit parkPeriodTimeUnit) {
            this.parkPeriod = parkPeriod;
            this.parkPeriodTimeUnit = parkPeriodTimeUnit;
            return this;
        }

        public long parkPeriod() {
            return this.parkPeriod;
        }

        public ReplicaChronicleQueueBuilder parkPeriod(long parkPeriod) {
            this.parkPeriod = parkPeriod;
            return this;
        }

        public TimeUnit parkPeriodTimeUnit() {
            return this.parkPeriodTimeUnit;
        }

        public ReplicaChronicleQueueBuilder parkPeriodTimeUnit(TimeUnit parkPeriodTimeUnit) {
            this.parkPeriodTimeUnit = parkPeriodTimeUnit;
            return this;
        }

        public long parkPeriodTimeNanos() {
            return this.parkPeriodTimeUnit.toNanos(this.parkPeriod);
        }

        public int selectorSpinLoopCount() {
            return this.selectorSpinLoopCount;
        }

        public ReplicaChronicleQueueBuilder selectorSpinLoopCount(int selectorSpinLoopCount) {
            if (selectorSpinLoopCount != -1 && selectorSpinLoopCount <= 0) {
                throw new IllegalArgumentException("SelectorSpinLoopCount must be greater than 0 or -1 (disabled)");
            }
            this.selectorSpinLoopCount = selectorSpinLoopCount;
            return this;
        }

        public int readSpinCount() {
            return this.readSpinCount;
        }

        public ReplicaChronicleQueueBuilder readSpinCount(int readSpinCount) {
            if (readSpinCount != -1 && readSpinCount <= 0) {
                throw new IllegalArgumentException("ReadSpinCount must be greater than 0 or -1 (disabled)");
            }
            this.readSpinCount = readSpinCount;
            return this;
        }

        public ReplicaChronicleQueueBuilder connectionListener(TcpConnectionListener connectionListener) {
            this.connectionListener = connectionListener;
            return this;
        }

        public boolean hasConnectionListener() {
            return this.connectionListener != null;
        }

        public TcpConnectionListener connectionListener() {
            return this.connectionListener;
        }

        public ReplicaChronicleQueueBuilder appendRequireAck(boolean appendRequireAck) {
            this.appendRequireAck = appendRequireAck;
            return this;
        }

        public boolean appendRequireAck() {
            return this.appendRequireAck;
        }

        public Chronicle chronicle() {
            return this.chronicle;
        }

        @Override
        public Chronicle build() throws IOException {
            if (this.builder != null) {
                this.chronicle = this.builder.build();
            }
            return this.doBuild();
        }

        @Override
        public ReplicaChronicleQueueBuilder withMapping(@Nullable MappingFunction mapping) {
            this.mapping = mapping;
            return this;
        }

        @Override
        public MappingFunction withMapping() {
            return this.mapping;
        }

        protected abstract Chronicle doBuild();

        @Override
        @NotNull
        public ReplicaChronicleQueueBuilder clone() {
            try {
                return (ReplicaChronicleQueueBuilder)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static class VanillaChronicleQueueBuilder
    extends ChronicleQueueBuilder {
        private final File path;
        private boolean synchronous;
        private boolean syncOnRoll;
        private boolean useCheckedExcerpt;
        private boolean useCompressedObjectSerializer;
        private String cycleFormat;
        private int cycleLength;
        private TimeZone cycleTimeZone;
        private int defaultMessageSize;
        private int dataCacheCapacity;
        private int indexCacheCapacity;
        private long indexBlockSize;
        private long dataBlockSize;
        private long entriesPerCycle;
        private boolean cleanupOnClose;
        private FileLifecycleListener fileLifecycleListener = FileLifecycleListener.FileLifecycleListeners.IGNORE;
        private boolean enableFsWatcher;

        private VanillaChronicleQueueBuilder(File path) {
            this.path = path;
            this.synchronous = false;
            this.syncOnRoll = true;
            this.useCheckedExcerpt = false;
            this.defaultMessageSize = 131072;
            this.dataCacheCapacity = 32;
            this.indexCacheCapacity = 32;
            this.indexBlockSize = 0x1000000L;
            this.dataBlockSize = 0x4000000L;
            this.cycleFormat = VanillaChronicle.Cycle.DAYS.format();
            this.cycleLength = VanillaChronicle.Cycle.DAYS.length();
            this.entriesPerCycle = VanillaChronicle.Cycle.DAYS.entries();
            this.cycleTimeZone = TimeZone.getTimeZone("GMT");
            this.cleanupOnClose = false;
            this.useCompressedObjectSerializer = true;
            this.enableFsWatcher = false;
        }

        protected File path() {
            return this.path;
        }

        public VanillaChronicleQueueBuilder synchronous(boolean synchronous) {
            this.synchronous = synchronous;
            return this;
        }

        public boolean syncOnRoll() {
            return this.syncOnRoll;
        }

        public VanillaChronicleQueueBuilder syncOnRoll(boolean syncOnRoll) {
            this.syncOnRoll = syncOnRoll;
            return this;
        }

        public boolean synchronous() {
            return this.synchronous;
        }

        public VanillaChronicleQueueBuilder useCheckedExcerpt(boolean useCheckedExcerpt) {
            this.useCheckedExcerpt = useCheckedExcerpt;
            return this;
        }

        public boolean useCheckedExcerpt() {
            return this.useCheckedExcerpt;
        }

        public boolean useCompressedObjectSerializer() {
            return this.useCompressedObjectSerializer;
        }

        public VanillaChronicleQueueBuilder useCompressedObjectSerializer(boolean useCompressedObjectSerializer) {
            this.useCompressedObjectSerializer = useCompressedObjectSerializer;
            return this;
        }

        public VanillaChronicleQueueBuilder cycleFormat(String cycleFormat) {
            this.cycleFormat = cycleFormat;
            return this;
        }

        public String cycleFormat() {
            return this.cycleFormat;
        }

        public VanillaChronicleQueueBuilder cycleLength(int cycleLength) {
            return this.cycleLength(cycleLength, true);
        }

        public VanillaChronicleQueueBuilder cycleLength(int cycleLength, boolean check) {
            if (check && (long)cycleLength < VanillaChronicle.MIN_CYCLE_LENGTH) {
                throw new IllegalArgumentException("Cycle length can't be less than " + VanillaChronicle.MIN_CYCLE_LENGTH + " ms!");
            }
            this.cycleLength = cycleLength;
            this.entriesPerCycle(VanillaChronicle.Cycle.forLength(this.cycleLength).entries());
            return this;
        }

        public int cycleLength() {
            return this.cycleLength;
        }

        public VanillaChronicleQueueBuilder cycleTimeZone(String timeZone) {
            this.cycleTimeZone = TimeZone.getTimeZone(timeZone);
            return this;
        }

        public VanillaChronicleQueueBuilder cycleTimeZone(TimeZone timeZone) {
            this.cycleTimeZone = timeZone;
            return this;
        }

        public TimeZone cycleTimeZone() {
            return this.cycleTimeZone;
        }

        public VanillaChronicleQueueBuilder indexBlockSize(long indexBlockSize) {
            this.indexBlockSize = indexBlockSize;
            return this;
        }

        public long indexBlockSize() {
            return this.indexBlockSize;
        }

        public long dataBlockSize() {
            return this.dataBlockSize;
        }

        public VanillaChronicleQueueBuilder dataBlockSize(long dataBlockSize) {
            this.dataBlockSize = dataBlockSize;
            return this;
        }

        public VanillaChronicleQueueBuilder cycle(VanillaChronicle.Cycle cycle) {
            this.cycleFormat(cycle.format());
            this.cycleLength(cycle.length(), false);
            this.entriesPerCycle(cycle.entries());
            return this;
        }

        public VanillaChronicleQueueBuilder entriesPerCycle(long entriesPerCycle) {
            if (entriesPerCycle < 256L) {
                throw new IllegalArgumentException("EntriesPerCycle must be at least 256");
            }
            if (entriesPerCycle > 0x1000000000000L) {
                throw new IllegalArgumentException("EntriesPerCycle must not exceed 1L << 48 (281474976710656)");
            }
            if (!Maths.isPowerOf2((long)entriesPerCycle)) {
                throw new IllegalArgumentException("EntriesPerCycle must be a power of 2");
            }
            this.entriesPerCycle = entriesPerCycle;
            return this;
        }

        public long entriesPerCycle() {
            return this.entriesPerCycle;
        }

        public VanillaChronicleQueueBuilder defaultMessageSize(int defaultMessageSize) {
            this.defaultMessageSize = defaultMessageSize;
            return this;
        }

        public int defaultMessageSize() {
            return this.defaultMessageSize;
        }

        public VanillaChronicleQueueBuilder cleanupOnClose(boolean cleanupOnClose) {
            this.cleanupOnClose = cleanupOnClose;
            return this;
        }

        public boolean cleanupOnClose() {
            return this.cleanupOnClose;
        }

        public VanillaChronicleQueueBuilder dataCacheCapacity(int dataCacheCapacity) {
            this.dataCacheCapacity = dataCacheCapacity;
            return this;
        }

        public int dataCacheCapacity() {
            return this.dataCacheCapacity;
        }

        public VanillaChronicleQueueBuilder indexCacheCapacity(int indexCacheCapacity) {
            this.indexCacheCapacity = indexCacheCapacity;
            return this;
        }

        public int indexCacheCapacity() {
            return this.indexCacheCapacity;
        }

        public ReplicaChronicleQueueBuilder sink() {
            return new SinkChronicleQueueBuilder(this);
        }

        public ReplicaChronicleQueueBuilder source() {
            return new SourceChronicleQueueBuilder(this);
        }

        public VanillaChronicleQueueBuilder fileLifecycleListener(FileLifecycleListener fileLifecycleListener) {
            this.fileLifecycleListener = fileLifecycleListener;
            return this;
        }

        public FileLifecycleListener fileLifecycleListener() {
            return this.fileLifecycleListener;
        }

        public boolean enableFsWatcher() {
            return this.enableFsWatcher;
        }

        public VanillaChronicleQueueBuilder enableFsWatcher(boolean enableFsWatcher) {
            this.enableFsWatcher = enableFsWatcher;
            return this;
        }

        @Override
        public Chronicle build() throws IOException {
            return new VanillaChronicle(this);
        }

        @Override
        @NotNull
        public VanillaChronicleQueueBuilder clone() {
            try {
                return (VanillaChronicleQueueBuilder)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static class IndexedChronicleQueueBuilder
    extends ChronicleQueueBuilder
    implements Cloneable {
        private final File path;
        private boolean synchronous;
        private boolean useCheckedExcerpt;
        private boolean useCompressedObjectSerializer;
        private int cacheLineSize;
        private int dataBlockSize;
        private int messageCapacity;
        private int indexBlockSize;
        private FileLifecycleListener fileLifecycleListener = FileLifecycleListener.FileLifecycleListeners.IGNORE;

        private IndexedChronicleQueueBuilder(File path) {
            this.path = path;
            this.synchronous = false;
            this.useCheckedExcerpt = false;
            this.useCompressedObjectSerializer = true;
            this.cacheLineSize = 64;
            this.dataBlockSize = Jvm.is64Bit() ? 0x8000000 : 0x1000000;
            this.indexBlockSize = Math.max(4096, this.dataBlockSize / 4);
            this.messageCapacity = 131072;
        }

        protected File path() {
            return this.path;
        }

        public IndexedChronicleQueueBuilder synchronous(boolean synchronous) {
            this.synchronous = synchronous;
            return this;
        }

        public boolean synchronous() {
            return this.synchronous;
        }

        public IndexedChronicleQueueBuilder useCheckedExcerpt(boolean useCheckedExcerpt) {
            this.useCheckedExcerpt = useCheckedExcerpt;
            return this;
        }

        public boolean useCheckedExcerpt() {
            return this.useCheckedExcerpt;
        }

        public boolean useCompressedObjectSerializer() {
            return this.useCompressedObjectSerializer;
        }

        public IndexedChronicleQueueBuilder useCompressedObjectSerializer(boolean useCompressedObjectSerializer) {
            this.useCompressedObjectSerializer = useCompressedObjectSerializer;
            return this;
        }

        public IndexedChronicleQueueBuilder cacheLineSize(int cacheLineSize) {
            this.cacheLineSize = cacheLineSize;
            return this;
        }

        public int cacheLineSize() {
            return this.cacheLineSize;
        }

        public IndexedChronicleQueueBuilder dataBlockSize(int dataBlockSize) {
            this.dataBlockSize = dataBlockSize;
            if (this.messageCapacity > dataBlockSize / 2) {
                this.messageCapacity = dataBlockSize / 2;
            }
            return this;
        }

        public int dataBlockSize() {
            return this.dataBlockSize;
        }

        public IndexedChronicleQueueBuilder indexBlockSize(int indexBlockSize) {
            this.indexBlockSize = indexBlockSize;
            return this;
        }

        public int indexBlockSize() {
            return this.indexBlockSize;
        }

        public IndexedChronicleQueueBuilder messageCapacity(int messageCapacity) {
            this.messageCapacity = messageCapacity;
            return this;
        }

        public int messageCapacity() {
            return this.messageCapacity;
        }

        public IndexedChronicleQueueBuilder small() {
            this.dataBlockSize(0x1000000);
            return this;
        }

        public IndexedChronicleQueueBuilder medium() {
            this.dataBlockSize(0x8000000);
            return this;
        }

        public IndexedChronicleQueueBuilder large() {
            this.dataBlockSize(0x20000000);
            return this;
        }

        IndexedChronicleQueueBuilder test() {
            this.dataBlockSize(8192);
            return this;
        }

        public ReplicaChronicleQueueBuilder sink() {
            return new SinkChronicleQueueBuilder(this);
        }

        public ReplicaChronicleQueueBuilder source() {
            return new SourceChronicleQueueBuilder(this);
        }

        @Deprecated
        public IndexedChronicleQueueBuilder fileGrowthListener(FileLifecycleListener fileLifecycleListener) {
            return this.fileLifecycleListener(fileLifecycleListener);
        }

        public IndexedChronicleQueueBuilder fileLifecycleListener(FileLifecycleListener fileLifecycleListener) {
            this.fileLifecycleListener = fileLifecycleListener;
            return this;
        }

        public FileLifecycleListener fileLifecycleListener() {
            return this.fileLifecycleListener;
        }

        @Override
        public Chronicle build() throws IOException {
            return new IndexedChronicle(this);
        }

        @Override
        @NotNull
        public IndexedChronicleQueueBuilder clone() {
            try {
                return (IndexedChronicleQueueBuilder)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

