/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import net.openhft.chronicle.ChronicleQueueBuilder;
import net.openhft.chronicle.VanillaChronicleUtils;
import net.openhft.chronicle.VanillaDateCache;
import net.openhft.lang.io.FileLifecycleListener;
import net.openhft.lang.io.VanillaMappedBytes;
import net.openhft.lang.io.VanillaMappedCache;
import net.openhft.lang.model.constraints.NotNull;

public class VanillaDataCache
implements Closeable {
    public static final String FILE_NAME_PREFIX = "data-";
    private final String basePath;
    private final DataKey key = new DataKey();
    private final int blockBits;
    private final VanillaDateCache dateCache;
    private final VanillaMappedCache<DataKey> cache;
    private final FileLifecycleListener fileLifecycleListener;

    VanillaDataCache(@NotNull ChronicleQueueBuilder.VanillaChronicleQueueBuilder builder, @NotNull VanillaDateCache dateCache, int blockBits) {
        this.fileLifecycleListener = builder.fileLifecycleListener();
        this.basePath = builder.path().getAbsolutePath();
        this.blockBits = blockBits;
        this.dateCache = dateCache;
        this.cache = new VanillaMappedCache(builder.dataCacheCapacity(), true, builder.cleanupOnClose());
    }

    @Override
    public synchronized void close() {
        this.cache.close();
    }

    int nextWordAlignment(int len) {
        return len + 3 & 0xFFFFFFFC;
    }

    public synchronized VanillaMappedBytes dataFor(int cycle, int threadId, int dataCount, boolean forWrite) throws IOException {
        this.key.cycle = cycle;
        this.key.threadId = threadId;
        this.key.dataCount = dataCount;
        VanillaMappedBytes vmb = this.cache.get((Object)this.key);
        if (vmb == null || vmb.refCount() < 1) {
            long start = System.nanoTime();
            File file = VanillaChronicleUtils.mkFiles(this.dateCache.valueFor((int)cycle).path, FILE_NAME_PREFIX + threadId + "-" + dataCount, forWrite);
            vmb = this.cache.put((Object)this.key.clone(), file, 1L << this.blockBits, (long)dataCount);
            this.fileLifecycleListener.onEvent(FileLifecycleListener.EventType.NEW, file, System.nanoTime() - start);
        }
        vmb.reserve();
        return vmb;
    }

    public File fileFor(int cycle, int threadId) {
        File cyclePath = this.dateCache.valueFor((int)cycle).path;
        String dataPrefix = FILE_NAME_PREFIX + threadId + "-";
        int maxCount = 0;
        File[] files = cyclePath.listFiles();
        if (files != null) {
            for (File file : files) {
                int count;
                if (!file.getName().startsWith(dataPrefix) || maxCount >= (count = Integer.parseInt(file.getName().substring(dataPrefix.length())))) continue;
                maxCount = count;
            }
        }
        return VanillaChronicleUtils.dataFileFor(cycle, threadId, maxCount, this.dateCache);
    }

    private void findEndOfData(VanillaMappedBytes buffer) {
        int max = 1 << this.blockBits;
        for (int i = 0; i < max; i += 4) {
            int len = buffer.readInt(buffer.position());
            if (len == 0) {
                return;
            }
            int len2 = this.nextWordAlignment(~len);
            if (len2 < 0) {
                throw new IllegalStateException("Corrupted length " + Integer.toHexString(len));
            }
            buffer.position(buffer.position() + (long)len2 + 4L);
        }
        throw new AssertionError();
    }

    public int findNextDataCount(int cycle, int threadId) {
        File cyclePath = this.dateCache.valueFor((int)cycle).path;
        String dataPrefix = FILE_NAME_PREFIX + threadId + "-";
        int maxCount = -1;
        File[] files = cyclePath.listFiles();
        if (files != null) {
            for (File file : files) {
                int count;
                if (!file.getName().startsWith(dataPrefix) || maxCount >= (count = Integer.parseInt(file.getName().substring(dataPrefix.length())))) continue;
                maxCount = count;
            }
        }
        return maxCount + 1;
    }

    public void checkCounts(int min, int max) {
        this.cache.checkCounts(min, max);
    }

    static class DataKey
    implements Cloneable {
        int cycle;
        int threadId;
        int dataCount;

        DataKey() {
        }

        public int hashCode() {
            return this.threadId * 10191 + this.cycle * 17 + this.dataCount;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DataKey)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            DataKey key = (DataKey)obj;
            return this.dataCount == key.dataCount && this.threadId == key.threadId && this.cycle == key.cycle;
        }

        protected DataKey clone() {
            try {
                return (DataKey)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        public String toString() {
            return "DataKey [cycle=" + this.cycle + "," + "threadId=" + this.threadId + "," + "dataCount=" + this.dataCount + "]";
        }
    }
}

