/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tcp;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Set;
import net.openhft.chronicle.ChronicleQueueBuilder;
import net.openhft.chronicle.tcp.Attached;
import net.openhft.chronicle.tcp.SinkTcp;
import net.openhft.chronicle.tcp.VanillaSelectionKeySet;
import net.openhft.chronicle.tcp.VanillaSelector;

public class SinkTcpAcceptor
extends SinkTcp {
    private ServerSocketChannel socketChannel = null;
    private VanillaSelector selector = null;

    public SinkTcpAcceptor(ChronicleQueueBuilder.ReplicaChronicleQueueBuilder builder) {
        super("sink-acceptor", builder);
    }

    @Override
    public SocketChannel openSocketChannel() throws IOException {
        if (this.socketChannel == null) {
            this.socketChannel = ServerSocketChannel.open();
            this.socketChannel.socket().setReuseAddress(true);
            this.socketChannel.socket().bind(this.builder.bindAddress());
            this.socketChannel.configureBlocking(false);
            this.selector = new VanillaSelector();
            this.selector.open();
            this.selector.register(this.socketChannel, 16, new Attached());
        }
        long selectTimeout = this.builder.selectTimeout();
        VanillaSelectionKeySet selectionKeys = this.selector.vanillaSelectionKeys();
        SocketChannel channel = null;
        int nbKeys = this.selector.select(0, selectTimeout);
        if (nbKeys > 0) {
            if (selectionKeys != null) {
                SelectionKey[] keys = selectionKeys.keys();
                int size = selectionKeys.size();
                for (int k = 0; k < size; ++k) {
                    SelectionKey key = keys[k];
                    if (key == null || !key.isAcceptable()) continue;
                    channel = this.socketChannel.accept();
                    this.logger.info("Accepted connection from: " + channel.getRemoteAddress());
                }
                selectionKeys.clear();
            } else {
                Set<SelectionKey> keys = this.selector.selectionKeys();
                for (SelectionKey key : keys) {
                    if (!key.isAcceptable()) continue;
                    channel = this.socketChannel.accept();
                    this.logger.info("Accepted connection from: " + channel.getRemoteAddress());
                }
                keys.clear();
            }
        }
        this.selector.close();
        this.selector = null;
        this.socketChannel.close();
        this.socketChannel = null;
        return channel;
    }

    @Override
    public boolean isLocalhost() {
        return true;
    }
}

