/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tools;

import java.nio.ByteBuffer;
import net.openhft.lang.io.DirectByteBufferBytes;

public class ResizableDirectByteBufferBytes
extends DirectByteBufferBytes {
    public ResizableDirectByteBufferBytes(int capacity) {
        super(capacity);
    }

    public ResizableDirectByteBufferBytes(ByteBuffer buffer) {
        super(buffer);
    }

    public ResizableDirectByteBufferBytes(ByteBuffer buffer, int start, int capacity) {
        super(buffer, start, capacity);
    }

    public ResizableDirectByteBufferBytes clearAll() {
        this.buffer().clear();
        this.clear();
        return this;
    }

    public ResizableDirectByteBufferBytes setBufferPositionAndLimit(int position, int limit) {
        this.buffer().position(position);
        this.buffer().limit(limit);
        return this;
    }

    public ResizableDirectByteBufferBytes setBufferPositionAndLimit(int position, long limit) {
        this.buffer().position(position);
        this.buffer().limit((int)limit);
        return this;
    }

    public ResizableDirectByteBufferBytes resizeIfNeeded(int newCapacity) {
        if (this.capacity() < (long)newCapacity) {
            this.resize(newCapacity, false, false);
        }
        return this;
    }

    public ResizableDirectByteBufferBytes resetToSize(int size) {
        if (this.capacity() < (long)size) {
            this.resize(size, false, false);
        } else {
            this.clear();
            this.buffer().clear();
            this.limit(size);
            this.buffer().limit(size);
        }
        return this;
    }
}

