/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class LogbackConfigurationListener
implements ServletContextListener {
    public static final String CONFIG_LOCATION_PARAM = "logbackConfiguration";
    public static final String FILE_URL_SCHEME = "file:";
    public static final String CLASSPATH_URL_SCHEME = "classpath:";

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        if (!(loggerFactory instanceof LoggerContext)) {
            servletContext.log("Can not configure logback. " + LoggerFactory.class + " is using " + loggerFactory + " which is not an instance of " + LoggerContext.class);
            return;
        }
        String configPath = StringSupport.trimOrNull(servletContext.getInitParameter(CONFIG_LOCATION_PARAM));
        if (configPath == null) {
            servletContext.log("Can not configure logback. Location is null. Maybe context param \"logbackConfiguration\" is not set or is not correct.");
            return;
        }
        URL url = this.toURL(servletContext, configPath);
        if (url == null) {
            servletContext.log("Can not configure logback. Could not find logback config neither as servlet context-, nor as classpath-, nor as url-, nor as file system resource. Config location = \"" + configPath + "\".");
            return;
        }
        servletContext.log("Configuring logback. Config location = \"" + configPath + "\", full url = \"" + url + "\".");
        this.configure(servletContext, url, (LoggerContext)loggerFactory);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        if (!(loggerFactory instanceof LoggerContext)) {
            return;
        }
        LoggerContext loggerContext = (LoggerContext)loggerFactory;
        loggerContext.stop();
    }

    protected void configure(ServletContext servletContext, URL configLocation, LoggerContext loggerContext) {
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)loggerContext);
        loggerContext.stop();
        try {
            configurator.doConfigure(configLocation);
        }
        catch (JoranException e) {
            servletContext.log("Failed to configure logback.", (Throwable)e);
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)loggerContext);
    }

    protected URL toURL(ServletContext servletContext, String location) {
        if (location.startsWith("/")) {
            File file = new File(location);
            if (!file.exists()) {
                servletContext.log("Logback configuration file " + location + " does not exist");
                return null;
            }
            if (!file.canRead()) {
                servletContext.log("Logback configuration file " + location + " is not readable");
                return null;
            }
            if (!file.isFile()) {
                servletContext.log("Logback configuration file " + location + " is not a file");
                return null;
            }
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                servletContext.log("Unable to convert logback File to a URL", (Throwable)e);
                return null;
            }
        }
        if (location.startsWith(CLASSPATH_URL_SCHEME)) {
            return Thread.currentThread().getContextClassLoader().getResource(location.substring(CLASSPATH_URL_SCHEME.length()));
        }
        servletContext.log("Logback configuration location is neither a file path nor a classpath url");
        return null;
    }
}

