/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import java.io.InputStream;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

@FunctionalInterface
public interface Classpath {
    public @Nullable InputStream findResource(String var1);

    default public Classpath exclude(Set<String> deletedEntries) {
        return resourcePath -> deletedEntries.contains(resourcePath) ? null : this.findResource(resourcePath);
    }

    default public Classpath delegateTo(Classpath c) {
        return path -> {
            InputStream p = this.findResource(path);
            if (p != null) {
                return p;
            }
            return c.findResource(path);
        };
    }

    public static Classpath forClassLoader(ClassLoader classLoader) {
        return classLoader::getResourceAsStream;
    }

    public static Classpath contextClasspath() {
        return Classpath.forClassLoader(Thread.currentThread().getContextClassLoader());
    }
}

