/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.types.BoxedPrimitive;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVisitor;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.lang.java.types.TypePrettyPrint;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.PSet;

public final class JPrimitiveType
implements JTypeMirror {
    Set<JTypeMirror> superTypes;
    private final TypeSystem ts;
    private final PrimitiveTypeKind kind;
    private final JClassSymbol type;
    private final JClassType box;
    private final PSet<SymbolicValue.SymAnnot> typeAnnots;

    JPrimitiveType(TypeSystem ts, PrimitiveTypeKind kind, JClassSymbol type, JClassSymbol boxType, PSet<SymbolicValue.SymAnnot> typeAnnots) {
        this.ts = ts;
        this.kind = kind;
        this.type = type;
        this.typeAnnots = typeAnnots;
        this.box = new BoxedPrimitive(ts, boxType, this, typeAnnots);
    }

    private JPrimitiveType(JPrimitiveType pType, PSet<SymbolicValue.SymAnnot> typeAnnots) {
        this(pType.ts, pType.kind, pType.type, pType.box.getSymbol(), typeAnnots);
        this.superTypes = pType.superTypes;
    }

    @Override
    public PSet<SymbolicValue.SymAnnot> getTypeAnnotations() {
        return this.typeAnnots;
    }

    @Override
    public JTypeMirror withAnnotations(PSet<SymbolicValue.SymAnnot> newTypeAnnots) {
        if (newTypeAnnots.isEmpty() && this.typeAnnots.isEmpty()) {
            return this;
        }
        return new JPrimitiveType(this, newTypeAnnots);
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.ts;
    }

    @Override
    public JClassType box() {
        return this.box;
    }

    @Override
    public JPrimitiveType unbox() {
        return this;
    }

    @Override
    public JTypeMirror getErasure() {
        return this;
    }

    @Override
    public @NonNull JClassSymbol getSymbol() {
        return this.type;
    }

    @Override
    public boolean isNumeric() {
        return this.kind != PrimitiveTypeKind.BOOLEAN;
    }

    @Override
    public boolean isPrimitive(PrimitiveTypeKind kind) {
        return this.kind == Objects.requireNonNull(kind, "null kind");
    }

    @Override
    public boolean isFloatingPoint() {
        return this.kind == PrimitiveTypeKind.DOUBLE || this.kind == PrimitiveTypeKind.FLOAT;
    }

    @Override
    public boolean isIntegral() {
        return this.kind != PrimitiveTypeKind.BOOLEAN && !this.isFloatingPoint();
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public Set<JTypeMirror> getSuperTypeSet() {
        return this.superTypes;
    }

    @Override
    public String toString() {
        return TypePrettyPrint.prettyPrint(this);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof JPrimitiveType && ((JPrimitiveType)obj).kind == this.kind;
    }

    public int hashCode() {
        return this.kind.hashCode();
    }

    public @NonNull String getSimpleName() {
        return this.kind.name;
    }

    public PrimitiveTypeKind getKind() {
        return this.kind;
    }

    @Override
    public <T, P> T acceptVisitor(JTypeVisitor<T, P> visitor, P p) {
        return visitor.visitPrimitive(this, p);
    }

    @Override
    public JTypeMirror subst(Function<? super SubstVar, ? extends @NonNull JTypeMirror> subst) {
        return this;
    }

    public static enum PrimitiveTypeKind {
        BOOLEAN(Boolean.TYPE),
        CHAR(Character.TYPE),
        BYTE(Byte.TYPE),
        SHORT(Short.TYPE),
        INT(Integer.TYPE),
        LONG(Long.TYPE),
        FLOAT(Float.TYPE),
        DOUBLE(Double.TYPE);

        final String name = this.name().toLowerCase(Locale.ROOT);
        private final Class<?> jvm;

        private PrimitiveTypeKind(Class<?> jvm) {
            this.jvm = jvm;
        }

        public String getSimpleName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public Class<?> jvmRepr() {
            return this.jvm;
        }

        public static @Nullable PrimitiveTypeKind fromName(String token) {
            switch (token) {
                case "boolean": {
                    return BOOLEAN;
                }
                case "char": {
                    return CHAR;
                }
                case "byte": {
                    return BYTE;
                }
                case "short": {
                    return SHORT;
                }
                case "int": {
                    return INT;
                }
                case "long": {
                    return LONG;
                }
                case "float": {
                    return FLOAT;
                }
                case "double": {
                    return DOUBLE;
                }
            }
            return null;
        }
    }
}

