/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.datafeed;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.datafeed.IDataSetProcessor;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.emf.common.util.EList;

public class DataSetAdapter
extends Methods
implements IDataSetProcessor {
    private transient ULocale lcl = null;
    protected static final String DELIMITER = ",";

    public DataSet fromString(String sDataSetRepresentation, DataSet ds) throws ChartException {
        return null;
    }

    public DataSet populate(Object oResultSetDef, DataSet ds) throws ChartException {
        return null;
    }

    public Object getMinimum(DataSet ds) throws ChartException {
        return null;
    }

    public Object getMaximum(DataSet ds) throws ChartException {
        return null;
    }

    public String getExpectedStringFormat() {
        return null;
    }

    public Locale getLocale() {
        return this.getULocale().toLocale();
    }

    public ULocale getULocale() {
        return this.lcl == null ? ULocale.getDefault() : this.lcl;
    }

    public final void setLocale(ULocale lcl) {
        this.lcl = lcl;
    }

    public String toString(Object[] columnData) throws ChartException {
        if (columnData == null || columnData.length == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.base.orthogonal.null.datadefinition", Messages.getResourceBundle(this.getULocale()));
        }
        StringBuffer buffer = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        int dataType = 0;
        int i = 0;
        while (i < columnData.length) {
            if (dataType > 0) break;
            if (columnData[i] instanceof Object[]) {
                columnData[i] = ((Object[])columnData[i])[0];
            }
            if (columnData[i] instanceof String) {
                dataType = 1;
            } else if (columnData[i] instanceof Date) {
                dataType = 2;
            } else if (columnData[i] instanceof Number) {
                dataType = 3;
            }
            ++i;
        }
        if (dataType == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.base.orthogonal.null.datadefinition", Messages.getResourceBundle(this.getULocale()));
        }
        i = 0;
        while (i < columnData.length) {
            if (columnData[i] instanceof Object[]) {
                columnData[i] = ((Object[])columnData[i])[0];
            }
            if (dataType == 1) {
                buffer.append("'" + this.formatString((String)columnData[i]) + "'");
            } else if (dataType == 2) {
                buffer.append(sdf.format((Date)columnData[i]));
            } else if (dataType == 3) {
                buffer.append(String.valueOf(columnData[i]));
            }
            if (i < columnData.length - 1) {
                buffer.append(DELIMITER);
            }
            ++i;
        }
        return buffer.toString();
    }

    protected String formatString(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("\\,", "\\\\,");
    }

    public List getDataDefinitionsForGrouping(Series series) {
        ArrayList<String> list = new ArrayList<String>(1);
        EList elDD = series.getDataDefinition();
        int n = 0;
        while (n < elDD.size()) {
            String sExpression = ((Query)elDD.get(n)).getDefinition();
            if (sExpression != null && sExpression.trim().length() > 0) {
                list.add(sExpression);
            }
            ++n;
        }
        return list;
    }
}

