/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class AreaRenderEvent
extends PrimitiveRenderEvent {
    private static final long serialVersionUID = 4924819106091024348L;
    protected final ArrayList alLinesAndArcs = new ArrayList();
    protected Fill fill;
    protected LineAttributes lia;
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/event");

    public AreaRenderEvent(Object oSource) {
        super(oSource);
    }

    public final void clear() {
        this.alLinesAndArcs.clear();
    }

    public void reset() {
        this.alLinesAndArcs.clear();
        this.fill = null;
        this.lia = null;
    }

    public final void add(PrimitiveRenderEvent pre) {
        this.alLinesAndArcs.add(pre);
    }

    public final int getElementCount() {
        return this.alLinesAndArcs.size();
    }

    public final Iterator iterator() {
        return this.alLinesAndArcs.iterator();
    }

    public final PrimitiveRenderEvent getElement(int i) {
        return (PrimitiveRenderEvent)this.alLinesAndArcs.get(i);
    }

    public final Fill getBackground() {
        return this.fill;
    }

    public final void setBackground(Fill fill) {
        this.fill = fill;
    }

    public final Bounds getBounds() {
        Bounds boFull = null;
        int i = 0;
        while (i < this.getElementCount()) {
            PrimitiveRenderEvent pre = this.getElement(i);
            try {
                Bounds bo = pre.getBounds();
                if (i == 0) {
                    boFull = BoundsImpl.copyInstance(bo);
                } else {
                    double dDelta;
                    if (bo.getLeft() < boFull.getLeft()) {
                        dDelta = boFull.getLeft() - bo.getLeft();
                        boFull.setLeft(boFull.getLeft() - dDelta);
                        boFull.setWidth(boFull.getWidth() + dDelta);
                    }
                    if (bo.getTop() < boFull.getTop()) {
                        dDelta = boFull.getTop() - bo.getTop();
                        boFull.setTop(boFull.getTop() - dDelta);
                        boFull.setHeight(boFull.getHeight() + dDelta);
                    }
                    if (bo.getLeft() + bo.getWidth() > boFull.getLeft() + boFull.getWidth()) {
                        dDelta = bo.getLeft() + bo.getWidth() - (boFull.getLeft() + boFull.getWidth());
                        boFull.setWidth(boFull.getWidth() + dDelta);
                    }
                    if (bo.getTop() + bo.getHeight() > boFull.getTop() + boFull.getHeight()) {
                        dDelta = bo.getTop() + bo.getHeight() - (boFull.getTop() + boFull.getHeight());
                        boFull.setHeight(boFull.getHeight() + dDelta);
                    }
                }
            }
            catch (ChartException ufex) {
                logger.log((Exception)((Object)ufex));
            }
            ++i;
        }
        return boFull;
    }

    public final LineAttributes getOutline() {
        return this.lia;
    }

    public final void setOutline(LineAttributes outline) {
        this.lia = outline;
    }

    public PrimitiveRenderEvent copy() throws ChartException {
        AreaRenderEvent are = new AreaRenderEvent(this.source);
        if (this.fill != null) {
            are.setBackground((Fill)EcoreUtil.copy((EObject)this.fill));
        }
        if (this.lia != null) {
            are.setOutline(LineAttributesImpl.copyInstance(this.lia));
        }
        Iterator itr = this.alLinesAndArcs.iterator();
        while (itr.hasNext()) {
            are.add(((PrimitiveRenderEvent)itr.next()).copy());
        }
        return are;
    }

    public void draw(IDeviceRenderer idr) throws ChartException {
        idr.drawArea(this);
    }

    public void fill(IDeviceRenderer idr) throws ChartException {
        idr.fillArea(this);
    }

    public LineAttributes getLineAttributes() {
        return this.getOutline();
    }
}

