/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.blacktie.plugins;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;

public class AddCommonSources
extends Task {
    private Reference mavenProjectRef;
    private String outputDir = "target";
    private String includes = ".*";

    public void execute() throws BuildException {
        MavenProject p = (MavenProject)this.mavenProjectRef.getProject().getReference(this.mavenProjectRef.getRefId());
        this.processResources(p);
    }

    public void setMavenProject(Reference ref) {
        this.mavenProjectRef = ref;
    }

    public void setOutputDir(String outDir) {
        this.outputDir = outDir;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    private void processResources(MavenProject p) {
        List resources = p.getResources();
        if (resources != null) {
            Iterator i = resources.iterator();
            while (i.hasNext()) {
                Resource resource = (Resource)i.next();
                String resourceRoot = resource.getDirectory();
                AddCommonSources.unzip(((Object)((Object)this)).getClass().getResourceAsStream("/cxx.jar"), this.outputDir, this.includes);
                p.addTestCompileSourceRoot(this.outputDir);
            }
        }
    }

    private static void unzip(InputStream from, String to, String pattern) {
        if (from == null || to == null) {
            return;
        }
        try {
            ZipEntry ze;
            ZipInputStream zs = new ZipInputStream(from);
            while ((ze = zs.getNextEntry()) != null) {
                boolean match;
                String fname = to + '/' + ze.getName();
                boolean bl = match = pattern == null || ze.getName().matches(pattern);
                if (ze.isDirectory()) {
                    new File(fname).mkdirs();
                } else if (match) {
                    AddCommonSources.externalizeFile(fname, zs);
                } else {
                    AddCommonSources.readFile(fname, zs);
                }
                zs.closeEntry();
            }
            zs.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to unpack archive: " + e.getMessage());
        }
    }

    private static void readFile(String fname, InputStream is) throws IOException {
        int len;
        File f = new File(fname);
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) > 0) {
        }
    }

    private static File externalizeFile(String fname, InputStream is) throws IOException {
        int len;
        File f = new File(fname);
        FileOutputStream out = new FileOutputStream(f);
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        return f;
    }
}

