/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.git;

import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.FetchResult;
import org.jboss.forge.addon.git.exceptions.CantMergeCommitException;
import org.jboss.forge.addon.resource.DirectoryResource;

public interface GitUtils {
    public Git clone(DirectoryResource var1, String var2) throws GitAPIException;

    public Git git(DirectoryResource var1) throws IOException;

    public Ref checkout(Git var1, String var2, boolean var3, CreateBranchCommand.SetupUpstreamMode var4, boolean var5) throws GitAPIException;

    public Ref checkout(Git var1, Ref var2, CreateBranchCommand.SetupUpstreamMode var3, boolean var4) throws GitAPIException;

    public FetchResult fetch(Git var1, String var2, String var3, int var4, boolean var5, boolean var6, boolean var7, boolean var8) throws GitAPIException;

    public Git init(DirectoryResource var1) throws IOException;

    public PullResult pull(Git var1, int var2) throws GitAPIException;

    public List<Ref> getRemoteBranches(Git var1) throws GitAPIException;

    public List<Ref> getLocalBranches(Git var1) throws GitAPIException;

    public String getCurrentBranchName(Git var1) throws IOException;

    public Ref switchBranch(Git var1, String var2);

    public List<String> getLogForCurrentBranch(Git var1) throws GitAPIException;

    public List<String> getLogForBranch(Git var1, String var2) throws GitAPIException, IOException;

    public void add(Git var1, String var2) throws GitAPIException;

    public void addAll(Git var1) throws GitAPIException;

    public void commit(Git var1, String var2) throws GitAPIException;

    public void commitAll(Git var1, String var2) throws GitAPIException;

    public void stashCreate(Git var1) throws GitAPIException;

    public void stashApply(Git var1, String ... var2) throws GitAPIException;

    public void stashDrop(Git var1) throws GitAPIException;

    public void cherryPick(Git var1, Ref var2) throws GitAPIException;

    public CherryPickResult cherryPickNoMerge(Git var1, Ref var2) throws GitAPIException, CantMergeCommitException;

    public void resetHard(Git var1, String var2) throws GitAPIException;

    public Ref createBranch(Git var1, String var2) throws GitAPIException;

    public void close(Git var1);
}

