package org.jboss.hal.client.runtime.host;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.typeahead.Typeahead;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.IdBuilder;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_HostView extends HostView {

    private final Metadata metadata34;
    private final Metadata metadata38;
    private final Metadata metadata36;
    private final Metadata metadata37;
    private final Metadata metadata35;
    private final Metadata metadata39;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_HostView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata34Template = AddressTemplate.of("/{selected.host}");
        this.metadata34 = mbuiContext.metadataRegistry().lookup(metadata34Template);
        AddressTemplate metadata38Template = AddressTemplate.of("/{selected.host}/socket-binding-group=*");
        this.metadata38 = mbuiContext.metadataRegistry().lookup(metadata38Template);
        AddressTemplate metadata36Template = AddressTemplate.of("/{selected.host}/jvm=*");
        this.metadata36 = mbuiContext.metadataRegistry().lookup(metadata36Template);
        AddressTemplate metadata37Template = AddressTemplate.of("/{selected.host}/path=*");
        this.metadata37 = mbuiContext.metadataRegistry().lookup(metadata37Template);
        AddressTemplate metadata35Template = AddressTemplate.of("/{selected.host}/interface=*");
        this.metadata35 = mbuiContext.metadataRegistry().lookup(metadata35Template);
        AddressTemplate metadata39Template = AddressTemplate.of("/{selected.host}/system-property=*");
        this.metadata39 = mbuiContext.metadataRegistry().lookup(metadata39Template);
        this.handlebarElements = new HashMap<>();

        hostConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.host.Host>("host-configuration-form", metadata34)
            .includeRuntime()
            .include("name", "organization", "directory-grouping", "uuid", "release-codename", "release-version", "product-name", "product-version", "management-major-version", "management-minor-version", "management-micro-version", "running-mode", "host-state", "suspend-state")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveHost(form, changedValues))
            .build();
        hostInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-interface-form", metadata35)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata35Template.resolve(mbuiContext.statementContext(), name),
                    "Interface", name);
            })
            .build();
        hostJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-jvm-form", metadata36)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata36Template.resolve(mbuiContext.statementContext(), name),
                    "Jvm", name);
            })
            .build();
        hostPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-path-form", metadata37)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata37Template.resolve(mbuiContext.statementContext(), name),
                    "Path", name);
            })
            .build();
        hostSocketBindingGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-socket-binding-group-form", metadata38)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata38Template.resolve(mbuiContext.statementContext(), name),
                    "Socket Binding Group", name);
            })
            .build();
        hostSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-system-property-form", metadata39)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata39Template.resolve(mbuiContext.statementContext(), name),
                    "System Property", name);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> hostInterfaceTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata35)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("host-interface-table", "add"), "Interface",
                metadata35Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata35Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostInterfaceTable = new ModelNodeTable<>("host-interface-table", hostInterfaceTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> hostJvmTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata36)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("host-jvm-table", "add"), "Jvm",
                metadata36Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Jvm", metadata36Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        hostJvmTable = new ModelNodeTable<>("host-jvm-table", hostJvmTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> hostPathTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata37)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("host-path-table", "add"), "Path",
                metadata37Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata37Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        hostPathTable = new ModelNodeTable<>("host-path-table", hostPathTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> hostSocketBindingGroupTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata38)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("host-socket-binding-group-table", "add"), "Socket Binding Group",
                metadata38Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Socket Binding Group", metadata38Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostSocketBindingGroupTable = new ModelNodeTable<>("host-socket-binding-group-table", hostSocketBindingGroupTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> hostSystemPropertyTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata39)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("host-system-property-table", "add"), "System Property",
                metadata39Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata39Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();
        hostSystemPropertyTable = new ModelNodeTable<>("host-system-property-table", hostSystemPropertyTableOptions);

        registerAttachable(hostConfigurationForm);
        registerAttachable(hostInterfaceTable);
        registerAttachable(hostInterfaceForm);
        registerAttachable(hostJvmTable);
        registerAttachable(hostJvmForm);
        registerAttachable(hostPathTable);
        registerAttachable(hostPathForm);
        registerAttachable(hostSocketBindingGroupTable);
        registerAttachable(hostSocketBindingGroupForm);
        registerAttachable(hostSystemPropertyTable);
        registerAttachable(hostSystemPropertyForm);

        navigation = new VerticalNavigation();
        Elements.Builder hostConfigurationItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"host-configuration-title\" /><p>{{metadata34.getDescription().getDescription()}}</p>"))
                    .rememberAs("html96")
                .end()
                .add(hostConfigurationForm)
            .end();
        Element hostConfigurationItemElement = hostConfigurationItemBuilder.build();
        handlebarElements.put("html96", hostConfigurationItemBuilder.referenceFor("html96"));
        navigation.addPrimary("host-configuration-item", "Configuration", "pficon pficon-cluster", hostConfigurationItemElement);
        Elements.Builder hostInterfaceItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>{{metadata35.getDescription().getDescription()}}</p>"))
                    .rememberAs("html98")
                .end()
                .add(hostInterfaceTable)
                .add(hostInterfaceForm)
            .end();
        Element hostInterfaceItemElement = hostInterfaceItemBuilder.build();
        handlebarElements.put("html98", hostInterfaceItemBuilder.referenceFor("html98"));
        navigation.addPrimary("host-interface-item", "Interfaces", "fa fa-exchange", hostInterfaceItemElement);
        Elements.Builder hostJvmItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>{{metadata36.getDescription().getDescription()}}</p>"))
                    .rememberAs("html101")
                .end()
                .add(hostJvmTable)
                .add(hostJvmForm)
            .end();
        Element hostJvmItemElement = hostJvmItemBuilder.build();
        handlebarElements.put("html101", hostJvmItemBuilder.referenceFor("html101"));
        navigation.addPrimary("host-jvm-item", "JVMs", "fa fa-coffee", hostJvmItemElement);
        Elements.Builder hostPathItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>{{metadata37.getDescription().getDescription()}}</p>"))
                    .rememberAs("html104")
                .end()
                .add(hostPathTable)
                .add(hostPathForm)
            .end();
        Element hostPathItemElement = hostPathItemBuilder.build();
        handlebarElements.put("html104", hostPathItemBuilder.referenceFor("html104"));
        navigation.addPrimary("host-path-item", "Paths", "fa fa-folder-open", hostPathItemElement);
        Elements.Builder hostSocketBindingGroupItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Binding Groups</h1><p>{{metadata38.getDescription().getDescription()}}</p>"))
                    .rememberAs("html107")
                .end()
                .add(hostSocketBindingGroupTable)
                .add(hostSocketBindingGroupForm)
            .end();
        Element hostSocketBindingGroupItemElement = hostSocketBindingGroupItemBuilder.build();
        handlebarElements.put("html107", hostSocketBindingGroupItemBuilder.referenceFor("html107"));
        navigation.addPrimary("host-socket-binding-group-item", "Socket Binding Groups", "fa fa-object-group", hostSocketBindingGroupItemElement);
        Elements.Builder hostSystemPropertyItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>{{metadata39.getDescription().getDescription()}}</p>"))
                    .rememberAs("html110")
                .end()
                .add(hostSystemPropertyTable)
                .add(hostSystemPropertyForm)
            .end();
        Element hostSystemPropertyItemElement = hostSystemPropertyItemBuilder.build();
        handlebarElements.put("html110", hostSystemPropertyItemBuilder.referenceFor("html110"));
        navigation.addPrimary("host-system-property-item", "System Properties", "fa fa-list-ul", hostSystemPropertyItemElement);

        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

        hostInterfaceTable.api().bindForm(hostInterfaceForm);
        hostJvmTable.api().bindForm(hostJvmForm);
        hostPathTable.api().bindForm(hostPathForm);
        hostSocketBindingGroupTable.api().bindForm(hostSocketBindingGroupForm);
        hostSystemPropertyTable.api().bindForm(hostSystemPropertyForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html96"), "{{metadata34.getDescription().getDescription()}}", String.valueOf(metadata34.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html98"), "{{metadata35.getDescription().getDescription()}}", String.valueOf(metadata35.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html101"), "{{metadata36.getDescription().getDescription()}}", String.valueOf(metadata36.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html104"), "{{metadata37.getDescription().getDescription()}}", String.valueOf(metadata37.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html107"), "{{metadata38.getDescription().getDescription()}}", String.valueOf(metadata38.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html110"), "{{metadata39.getDescription().getDescription()}}", String.valueOf(metadata39.getDescription().getDescription()));
    }
}
