package org.jboss.hal.client.runtime.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.typeahead.Typeahead;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.IdBuilder;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_ServerView extends ServerView {

    private final Metadata metadata44;
    private final Metadata metadata40;
    private final Metadata metadata43;
    private final Metadata metadata42;
    private final Metadata metadata41;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_ServerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata44Template = AddressTemplate.of("/{selected.host}/{selected.server}/system-property=*");
        this.metadata44 = mbuiContext.metadataRegistry().lookup(metadata44Template);
        AddressTemplate metadata40Template = AddressTemplate.of("/{selected.host}/{selected.server}");
        this.metadata40 = mbuiContext.metadataRegistry().lookup(metadata40Template);
        AddressTemplate metadata43Template = AddressTemplate.of("/{selected.host}/{selected.server}/path=*");
        this.metadata43 = mbuiContext.metadataRegistry().lookup(metadata43Template);
        AddressTemplate metadata42Template = AddressTemplate.of("/{selected.host}/{selected.server}/jvm=*");
        this.metadata42 = mbuiContext.metadataRegistry().lookup(metadata42Template);
        AddressTemplate metadata41Template = AddressTemplate.of("/{selected.host}/{selected.server}/interface=*");
        this.metadata41 = mbuiContext.metadataRegistry().lookup(metadata41Template);
        this.handlebarElements = new HashMap<>();

        serverConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.server.Server>("server-configuration-form", metadata40)
            .includeRuntime()
            .include("name", "group", "auto-start", "update-auto-start-with-server-status", "socket-binding-group", "socket-binding-port-offset", "socket-binding-default-interface", "status")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm(changedValues, metadata40Template.resolve(mbuiContext.statementContext()), "Server Configuration"))
            .build();
        serverInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-interface-form", metadata41)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata41Template.resolve(mbuiContext.statementContext(), name),
                    "Interface", name);
            })
            .build();
        serverJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-jvm-form", metadata42)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata42Template.resolve(mbuiContext.statementContext(), name),
                    "Jvm", name);
            })
            .build();
        serverPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-path-form", metadata43)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata43Template.resolve(mbuiContext.statementContext(), name),
                    "Path", name);
            })
            .build();
        serverSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-system-property-form", metadata44)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata44Template.resolve(mbuiContext.statementContext(), name),
                    "System Property", name);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> serverInterfaceTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata41)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("server-interface-table", "add"), "Interface",
                metadata41Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata41Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        serverInterfaceTable = new ModelNodeTable<>("server-interface-table", serverInterfaceTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> serverJvmTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata42)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("server-jvm-table", "add"), "Jvm",
                metadata42Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Jvm", metadata42Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverJvmTable = new ModelNodeTable<>("server-jvm-table", serverJvmTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> serverPathTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata43)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("server-path-table", "add"), "Path",
                metadata43Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata43Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        serverPathTable = new ModelNodeTable<>("server-path-table", serverPathTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> serverSystemPropertyTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata44)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("server-system-property-table", "add"), "System Property",
                metadata44Template,
                () -> presenter.reload(),
                "value"))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata44Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();
        serverSystemPropertyTable = new ModelNodeTable<>("server-system-property-table", serverSystemPropertyTableOptions);

        registerAttachable(serverConfigurationForm);
        registerAttachable(serverInterfaceTable);
        registerAttachable(serverInterfaceForm);
        registerAttachable(serverJvmTable);
        registerAttachable(serverJvmForm);
        registerAttachable(serverPathTable);
        registerAttachable(serverPathForm);
        registerAttachable(serverSystemPropertyTable);
        registerAttachable(serverSystemPropertyForm);

        navigation = new VerticalNavigation();
        Elements.Builder serverConfigurationItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Configuration</h1><p>{{metadata40.getDescription().getDescription()}}</p>"))
                    .rememberAs("html113")
                .end()
                .add(serverConfigurationForm)
            .end();
        Element serverConfigurationItemElement = serverConfigurationItemBuilder.build();
        handlebarElements.put("html113", serverConfigurationItemBuilder.referenceFor("html113"));
        navigation.addPrimary("server-configuration-item", "Configuration", "pficon pficon-cluster", serverConfigurationItemElement);
        Elements.Builder serverInterfaceItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>{{metadata41.getDescription().getDescription()}}</p>"))
                    .rememberAs("html115")
                .end()
                .add(serverInterfaceTable)
                .add(serverInterfaceForm)
            .end();
        Element serverInterfaceItemElement = serverInterfaceItemBuilder.build();
        handlebarElements.put("html115", serverInterfaceItemBuilder.referenceFor("html115"));
        navigation.addPrimary("server-interface-item", "Interfaces", "fa fa-exchange", serverInterfaceItemElement);
        Elements.Builder serverJvmItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>{{metadata42.getDescription().getDescription()}}</p>"))
                    .rememberAs("html118")
                .end()
                .add(serverJvmTable)
                .add(serverJvmForm)
            .end();
        Element serverJvmItemElement = serverJvmItemBuilder.build();
        handlebarElements.put("html118", serverJvmItemBuilder.referenceFor("html118"));
        navigation.addPrimary("server-jvm-item", "JVMs", "fa fa-coffee", serverJvmItemElement);
        Elements.Builder serverPathItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>{{metadata43.getDescription().getDescription()}}</p>"))
                    .rememberAs("html121")
                .end()
                .add(serverPathTable)
                .add(serverPathForm)
            .end();
        Element serverPathItemElement = serverPathItemBuilder.build();
        handlebarElements.put("html121", serverPathItemBuilder.referenceFor("html121"));
        navigation.addPrimary("server-path-item", "Paths", "fa fa-folder-open", serverPathItemElement);
        Elements.Builder serverSystemPropertyItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>{{metadata44.getDescription().getDescription()}}</p>"))
                    .rememberAs("html124")
                .end()
                .add(serverSystemPropertyTable)
                .add(serverSystemPropertyForm)
            .end();
        Element serverSystemPropertyItemElement = serverSystemPropertyItemBuilder.build();
        handlebarElements.put("html124", serverSystemPropertyItemBuilder.referenceFor("html124"));
        navigation.addPrimary("server-system-property-item", "System Properties", "fa fa-list-ul", serverSystemPropertyItemElement);

        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

        serverInterfaceTable.api().bindForm(serverInterfaceForm);
        serverJvmTable.api().bindForm(serverJvmForm);
        serverPathTable.api().bindForm(serverPathForm);
        serverSystemPropertyTable.api().bindForm(serverSystemPropertyForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html113"), "{{metadata40.getDescription().getDescription()}}", String.valueOf(metadata40.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html115"), "{{metadata41.getDescription().getDescription()}}", String.valueOf(metadata41.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html118"), "{{metadata42.getDescription().getDescription()}}", String.valueOf(metadata42.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html121"), "{{metadata43.getDescription().getDescription()}}", String.valueOf(metadata43.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html124"), "{{metadata44.getDescription().getDescription()}}", String.valueOf(metadata44.getDescription().getDescription()));
    }
}
