/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pull.shared;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.PullRequest;
import org.jboss.pull.shared.ProcessorPullState;
import org.jboss.pull.shared.UserList;
import org.jboss.pull.shared.Util;
import org.jboss.pull.shared.connectors.RedhatPullRequest;
import org.jboss.pull.shared.connectors.bugzilla.BZHelper;
import org.jboss.pull.shared.connectors.github.GithubHelper;
import org.jboss.pull.shared.evaluators.PullEvaluatorFacade;
import org.jboss.pull.shared.spi.PullEvaluator;

public class PullHelper {
    public static final Pattern BUILD_OUTCOME = Pattern.compile("outcome was (\\*\\*)?+(SUCCESS|FAILURE|ABORTED)(\\*\\*)?+ using a merge of ([a-z0-9]+)", 2);
    public static final Pattern PENDING = Pattern.compile(".*Build.*merging.*has\\W+been\\W+triggered.*", 34);
    public static final Pattern RUNNING = Pattern.compile(".*Build.*merging.*has\\W+been\\W+started.*", 34);
    public static final Pattern FINISHED = Pattern.compile(".*Build.*merging.*has\\W+been\\W+finished.*", 34);
    public static final Pattern MERGE = Pattern.compile(".*(re)?merge\\W+this\\W+please.*", 34);
    public static final Pattern FORCE_MERGE = Pattern.compile(".*force\\W+merge\\W+this.*", 34);
    private final PullEvaluatorFacade evaluatorFacade;
    private final UserList adminList;
    private final GithubHelper ghHelper;
    private final BZHelper bzHelper;
    private final Properties props;

    public Properties getProperties() {
        return this.props;
    }

    public PullHelper(String configurationFileProperty, String configurationFileDefault) throws Exception {
        try {
            this.ghHelper = new GithubHelper(configurationFileProperty, configurationFileDefault);
            this.bzHelper = new BZHelper(configurationFileProperty, configurationFileDefault);
            this.props = Util.loadProperties(configurationFileProperty, configurationFileDefault);
            this.evaluatorFacade = new PullEvaluatorFacade(this, this.props);
            this.adminList = UserList.loadUserList(Util.require(this.props, "admin.list.file"));
        }
        catch (Exception e) {
            System.err.printf("Cannot initialize: %s\n", e);
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public PullEvaluatorFacade getEvaluatorFacade() {
        return this.evaluatorFacade;
    }

    public List<RedhatPullRequest> getOpenPullRequests() {
        List<PullRequest> pullRequests = this.ghHelper.getPullRequests("open");
        ArrayList<RedhatPullRequest> redhatPullRequests = new ArrayList<RedhatPullRequest>();
        for (PullRequest pullRequest : pullRequests) {
            redhatPullRequests.add(new RedhatPullRequest(pullRequest, this.bzHelper, this.ghHelper));
        }
        return redhatPullRequests;
    }

    public RedhatPullRequest getPullRequest(String organization, String repository, int id) {
        PullRequest pullRequest = this.ghHelper.getPullRequest(organization, repository, id);
        return new RedhatPullRequest(pullRequest, this.bzHelper, this.ghHelper);
    }

    public List<Milestone> getGithubMilestones() {
        return this.ghHelper.getMilestones();
    }

    public Milestone createMilestone(String title) {
        return this.ghHelper.createMilestone(title);
    }

    public ProcessorPullState checkPullRequestState(RedhatPullRequest pullRequest) {
        ProcessorPullState result = ProcessorPullState.NEW;
        List<Comment> comments = pullRequest.getGithubComments();
        for (Comment comment : comments) {
            if (this.ghHelper.getGithubLogin().equals(comment.getUser().getLogin())) {
                if (PENDING.matcher(comment.getBody()).matches()) {
                    result = ProcessorPullState.PENDING;
                    continue;
                }
                if (RUNNING.matcher(comment.getBody()).matches()) {
                    result = ProcessorPullState.RUNNING;
                    continue;
                }
                if (FINISHED.matcher(comment.getBody()).matches()) {
                    result = ProcessorPullState.FINISHED;
                    continue;
                }
            }
            if (!MERGE.matcher(comment.getBody()).matches()) continue;
            result = ProcessorPullState.MERGEABLE;
        }
        if (result == ProcessorPullState.MERGEABLE || result == ProcessorPullState.NEW) {
            Comment lastComment;
            PullEvaluator.Result mergeable = this.evaluatorFacade.isMergeable(pullRequest);
            if (!mergeable.isMergeable()) {
                result = ProcessorPullState.INCOMPLETE;
            }
            if (result == ProcessorPullState.INCOMPLETE && !comments.isEmpty() && FORCE_MERGE.matcher((lastComment = comments.get(comments.size() - 1)).getBody()).matches() && this.isAdminUser(lastComment.getUser().getLogin())) {
                result = ProcessorPullState.MERGEABLE;
            }
        }
        return result;
    }

    public boolean isAdminUser(String username) {
        return this.adminList.has(username);
    }
}

