/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pull.shared.evaluators;

import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.pull.shared.PullHelper;
import org.jboss.pull.shared.Util;
import org.jboss.pull.shared.connectors.RedhatPullRequest;
import org.jboss.pull.shared.connectors.bugzilla.Bug;
import org.jboss.pull.shared.connectors.common.Issue;
import org.jboss.pull.shared.evaluators.BasePullEvaluator;
import org.jboss.pull.shared.spi.PullEvaluator;

public class ParentBugBasedPullEvaluator
extends BasePullEvaluator {
    public static final String PARENT_BUGS_PROPERTY = "parent.bug";
    protected final Set<Integer> REQUIRED_PARENTS = new HashSet<Integer>();

    @Override
    public void init(PullHelper helper, Properties configuration, String version) {
        super.init(helper, configuration, version);
        String parentBugs = Util.require(configuration, version + "." + PARENT_BUGS_PROPERTY);
        StringTokenizer tokenizer = new StringTokenizer(parentBugs, ", ");
        while (tokenizer.hasMoreTokens()) {
            String parentBug = tokenizer.nextToken();
            this.REQUIRED_PARENTS.add(Integer.valueOf(parentBug));
        }
    }

    @Override
    public PullEvaluator.Result isMergeable(RedhatPullRequest pull) {
        PullEvaluator.Result mergeable = super.isMergeable(pull);
        mergeable.and(this.isMergeableByBugzilla(pull));
        return mergeable;
    }

    protected PullEvaluator.Result isMergeableByBugzilla(RedhatPullRequest pull) {
        PullEvaluator.Result mergeable = new PullEvaluator.Result(false);
        List<? extends Issue> bugs = this.getIssue(pull);
        if (bugs.isEmpty()) {
            mergeable.addDescription("- Missing any bugzilla bug");
            return mergeable;
        }
        for (Bug bug : bugs) {
            Set<Integer> blocks = bug.getBlocks();
            if (blocks == null || blocks.isEmpty()) continue;
            boolean hit = false;
            for (Integer parentBug : this.REQUIRED_PARENTS) {
                if (!blocks.contains(parentBug)) continue;
                hit = true;
            }
            mergeable.setMergeable(mergeable.isMergeable() || hit);
        }
        if (mergeable.isMergeable()) {
            mergeable.addDescription("+ Bugzilla is OK");
        } else {
            mergeable.addDescription(this.missingParentsDescription());
        }
        return mergeable;
    }

    private String missingParentsDescription() {
        StringBuilder description = new StringBuilder("- Referenced BZs should block ");
        if (this.REQUIRED_PARENTS.size() > 1) {
            description.append("at least one of ");
        }
        String delim = " ";
        for (Integer requiredParent : this.REQUIRED_PARENTS) {
            description.append(delim).append("bz").append(requiredParent);
            delim = ", ";
        }
        return description.toString();
    }
}

