/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pull.shared.evaluators;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.pull.shared.PullHelper;
import org.jboss.pull.shared.Util;
import org.jboss.pull.shared.connectors.RedhatPullRequest;
import org.jboss.pull.shared.connectors.common.Issue;
import org.jboss.pull.shared.spi.PullEvaluator;

public class PullEvaluatorFacade {
    private final Map<String, PullEvaluator> evaluators = new HashMap<String, PullEvaluator>();

    public PullEvaluatorFacade(PullHelper helper, Properties configuration) {
        String versions = Util.require(configuration, "versions");
        StringTokenizer tokenizer = new StringTokenizer(versions, ", ");
        while (tokenizer.hasMoreTokens()) {
            String version = tokenizer.nextToken();
            String evaluatorClassName = Util.require(configuration, version + "." + "evaluator");
            try {
                Class<?> evaluatorClass = Class.forName(evaluatorClassName);
                Constructor<?> ctor = evaluatorClass.getConstructor(new Class[0]);
                PullEvaluator evaluator = (PullEvaluator)ctor.newInstance(new Object[0]);
                evaluator.init(helper, configuration, version);
                String evaluatorTargetBranch = evaluator.getTargetBranch();
                if (this.evaluators.containsKey(evaluatorTargetBranch)) {
                    throw new IllegalStateException("Multiple evaluators dedicated to the branch " + evaluatorTargetBranch);
                }
                this.evaluators.put(evaluatorTargetBranch, evaluator);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public PullEvaluator.Result isMergeable(RedhatPullRequest pull) {
        PullEvaluator evaluator = this.getPullEvaluator(pull);
        return evaluator.isMergeable(pull);
    }

    public List<? extends Issue> getIssue(RedhatPullRequest pull) {
        PullEvaluator evaluator = this.getPullEvaluator(pull);
        return evaluator.getIssue(pull);
    }

    public List<RedhatPullRequest> getUpstreamPullRequest(RedhatPullRequest pull) {
        PullEvaluator evaluator = this.getPullEvaluator(pull);
        return evaluator.getUpstreamPullRequest(pull);
    }

    public boolean updateIssueAsMerged(RedhatPullRequest pull) {
        PullEvaluator evaluator = this.getPullEvaluator(pull);
        return evaluator.updateIssueAsMerged(pull);
    }

    private PullEvaluator getPullEvaluator(RedhatPullRequest pull) {
        String targetBranch = pull.getTargetBranchTitle();
        PullEvaluator evaluator = this.evaluators.get(targetBranch);
        if (evaluator == null) {
            throw new IllegalStateException("Couldn't find any evaluator for target github branch " + targetBranch);
        }
        return evaluator;
    }

    public Set<String> getCoveredBranches() {
        return new HashSet<String>(this.evaluators.keySet());
    }
}

