/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pull.shared.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.jboss.pull.shared.PullHelper;
import org.jboss.pull.shared.connectors.RedhatPullRequest;
import org.jboss.pull.shared.connectors.common.Issue;

public interface PullEvaluator {
    public void init(PullHelper var1, Properties var2, String var3);

    public String getTargetBranch();

    public Result isMergeable(RedhatPullRequest var1);

    public List<? extends Issue> getIssue(RedhatPullRequest var1);

    public List<RedhatPullRequest> getUpstreamPullRequest(RedhatPullRequest var1);

    public boolean updateIssueAsMerged(RedhatPullRequest var1);

    public static class Result {
        private boolean mergeable;
        private List<String> description;

        public Result() {
            this.description = new ArrayList<String>();
        }

        public Result(boolean mergeable) {
            this.mergeable = mergeable;
            this.description = new ArrayList<String>();
        }

        public Result(boolean mergeable, String ... description) {
            this.mergeable = mergeable;
            this.description = new ArrayList<String>(Arrays.asList(description));
        }

        public boolean isMergeable() {
            return this.mergeable;
        }

        public void setMergeable(boolean mergeable) {
            this.mergeable = mergeable;
        }

        public List<String> getDescription() {
            return this.description;
        }

        public void addDescription(String ... description) {
            this.description.addAll(Arrays.asList(description));
        }

        public void addDescription(List<String> description) {
            this.description.addAll(description);
        }

        public Result and(Result other) {
            this.setMergeable(this.isMergeable() && other.isMergeable());
            this.addDescription(other.getDescription());
            return this;
        }
    }
}

