/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pull.shared;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.RepositoryBranch;
import org.jboss.pull.shared.Constants;
import org.jboss.pull.shared.ProcessorPullState;
import org.jboss.pull.shared.UserList;
import org.jboss.pull.shared.Util;
import org.jboss.pull.shared.connectors.IssueHelper;
import org.jboss.pull.shared.connectors.RedhatPullRequest;
import org.jboss.pull.shared.connectors.bugzilla.BZHelper;
import org.jboss.pull.shared.connectors.github.GithubHelper;
import org.jboss.pull.shared.connectors.jira.JiraHelper;
import org.jboss.pull.shared.evaluators.PullEvaluatorFacade;
import org.jboss.pull.shared.spi.PullEvaluator;

public class PullHelper {
    private final PullEvaluatorFacade evaluatorFacade;
    private final UserList adminList;
    private GithubHelper ghHelper;
    private IssueHelper bzHelper;
    private IssueHelper jiraHelper;
    private final Properties props;

    public Properties getProperties() {
        return this.props;
    }

    public PullHelper(String configurationFileProperty, String configurationFileDefault) throws Exception {
        try {
            this.ghHelper = new GithubHelper(configurationFileProperty, configurationFileDefault);
            this.bzHelper = new BZHelper(configurationFileProperty, configurationFileDefault);
            this.jiraHelper = new JiraHelper(configurationFileProperty, configurationFileDefault);
            this.props = Util.loadProperties(configurationFileProperty, configurationFileDefault);
            this.evaluatorFacade = new PullEvaluatorFacade(this, this.props);
            this.adminList = UserList.loadUserList(Util.require(this.props, "admin.list.file"));
        }
        catch (Exception e) {
            System.err.printf("Cannot initialize: %s\n", e);
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public List<String> getBranches() {
        List<RepositoryBranch> branches = this.ghHelper.getBranches();
        ArrayList<String> branchNames = new ArrayList<String>();
        for (RepositoryBranch branch : branches) {
            String branchName = branch.getName();
            if (branchName.contains("ignore") || branchName.contains("proposed")) continue;
            branchNames.add(branchName);
        }
        return branchNames;
    }

    public PullEvaluatorFacade getEvaluatorFacade() {
        return this.evaluatorFacade;
    }

    public List<RedhatPullRequest> getOpenPullRequests() {
        List<PullRequest> pullRequests = this.ghHelper.getPullRequests("open");
        ArrayList<RedhatPullRequest> redhatPullRequests = new ArrayList<RedhatPullRequest>();
        for (PullRequest pullRequest : pullRequests) {
            redhatPullRequests.add(new RedhatPullRequest(pullRequest, this.bzHelper, this.jiraHelper, this.ghHelper));
        }
        return redhatPullRequests;
    }

    public RedhatPullRequest getPullRequest(String organization, String repository, int id) {
        PullRequest pullRequest = this.ghHelper.getPullRequest(organization, repository, id);
        return new RedhatPullRequest(pullRequest, this.bzHelper, this.jiraHelper, this.ghHelper);
    }

    public List<Milestone> getGithubMilestones() {
        return this.ghHelper.getMilestones();
    }

    public Milestone createMilestone(String title) {
        return this.ghHelper.createMilestone(title);
    }

    public ProcessorPullState checkPullRequestState(RedhatPullRequest pullRequest) {
        ProcessorPullState result = ProcessorPullState.NEW;
        List<Comment> comments = pullRequest.getGithubComments();
        for (Comment comment : comments) {
            if (this.ghHelper.getGithubLogin().equals(comment.getUser().getLogin())) {
                if (Constants.PENDING.matcher(comment.getBody()).matches()) {
                    result = ProcessorPullState.PENDING;
                    continue;
                }
                if (Constants.RUNNING.matcher(comment.getBody()).matches()) {
                    result = ProcessorPullState.RUNNING;
                    continue;
                }
                if (Constants.FINISHED.matcher(comment.getBody()).matches()) {
                    result = ProcessorPullState.FINISHED;
                    continue;
                }
            }
            if (!Constants.MERGE.matcher(comment.getBody()).matches()) continue;
            result = ProcessorPullState.MERGEABLE;
        }
        if (result == ProcessorPullState.MERGEABLE || result == ProcessorPullState.NEW) {
            Comment lastComment;
            PullEvaluator.Result mergeable = this.evaluatorFacade.isMergeable(pullRequest);
            if (!mergeable.isMergeable()) {
                result = ProcessorPullState.INCOMPLETE;
            }
            if (result == ProcessorPullState.INCOMPLETE && !comments.isEmpty() && Constants.FORCE_MERGE.matcher((lastComment = comments.get(comments.size() - 1)).getBody()).matches() && this.isAdminUser(lastComment.getUser().getLogin())) {
                result = ProcessorPullState.MERGEABLE;
            }
        }
        return result;
    }

    public boolean isAdminUser(String username) {
        return this.adminList.has(username);
    }

    public Label getLabel(String title) {
        return this.ghHelper.getLabel(title);
    }
}

