/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pull.shared;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.jboss.pull.shared.Util;

public class UserList {
    private final Set<String> list;
    private final File file;

    private UserList(Set<String> list, File file) {
        this.list = list;
        this.file = file;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UserList loadUserList(String fileName) {
        UserList userList;
        BufferedReader reader = null;
        try {
            String line;
            File file = new File(fileName);
            file.createNewFile();
            reader = new BufferedReader(new FileReader(file));
            HashSet<String> list = new HashSet<String>();
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
            userList = new UserList(list, file);
        }
        catch (FileNotFoundException e) {
            try {
                throw new IllegalStateException(e);
                catch (IOException e2) {
                    throw new IllegalStateException(e2);
                }
            }
            catch (Throwable throwable) {
                Util.safeClose(reader);
                throw throwable;
            }
        }
        Util.safeClose(reader);
        return userList;
    }

    public boolean has(String name) {
        return this.list.contains(name);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(String user) {
        this.list.add(user);
        PrintWriter stream = null;
        try {
            stream = new PrintWriter(new FileOutputStream(this.file, true));
            stream.println(user);
        }
        catch (FileNotFoundException e) {
            try {
                throw new IllegalStateException(e);
                catch (IOException e2) {
                    throw new IllegalStateException(e2);
                }
            }
            catch (Throwable throwable) {
                Util.safeClose(stream);
                throw throwable;
            }
        }
        Util.safeClose(stream);
    }
}

