/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pull.shared.connectors;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.User;
import org.jboss.pull.shared.BuildResult;
import org.jboss.pull.shared.Constants;
import org.jboss.pull.shared.connectors.IssueHelper;
import org.jboss.pull.shared.connectors.bugzilla.BZHelper;
import org.jboss.pull.shared.connectors.bugzilla.Bug;
import org.jboss.pull.shared.connectors.common.Issue;
import org.jboss.pull.shared.connectors.github.GithubHelper;
import org.jboss.pull.shared.connectors.jira.JiraHelper;
import org.jboss.pull.shared.connectors.jira.JiraIssue;

public class RedhatPullRequest {
    private PullRequest pullRequest;
    private List<Issue> bugs = null;
    private List<Issue> jiraIssues = null;
    private List<RedhatPullRequest> relatedPullRequests = null;
    private IssueHelper bzHelper;
    private IssueHelper jiraHelper;
    private GithubHelper ghHelper;

    public RedhatPullRequest(PullRequest pullRequest, IssueHelper bzHelper, IssueHelper jiraHelper, GithubHelper ghHelper) {
        this.pullRequest = pullRequest;
        if (!(bzHelper instanceof BZHelper) || !(jiraHelper instanceof JiraHelper)) {
            throw new IllegalArgumentException("The first IssueHelper parameter has to be an instance of BZHelper and the second IssueHelper parameter must be an instance of JiraHelper.");
        }
        this.bzHelper = bzHelper;
        this.jiraHelper = jiraHelper;
        this.ghHelper = ghHelper;
        this.bugs = this.getBugsFromDescription();
        this.jiraIssues = this.getJiraIssuesFromDescription();
    }

    public boolean hasBZLinkInDescription() {
        return this.extractURLs("https://bugzilla.redhat.com/show_bug.cgi?id=", Constants.BUGZILLA_ID_PATTERN).size() > 0;
    }

    private List<Issue> getBugsFromDescription() {
        List<URL> urls = this.extractURLs("https://bugzilla.redhat.com/show_bug.cgi?id=", Constants.BUGZILLA_ID_PATTERN);
        ArrayList<Issue> bugs = new ArrayList<Issue>();
        for (URL url : urls) {
            Bug bug;
            if (!this.bzHelper.accepts(url) || (bug = (Bug)this.bzHelper.findIssue(url)) == null) continue;
            bugs.add(bug);
        }
        return bugs;
    }

    public boolean hasJiraLinkInDescription() {
        return this.extractURLs("https://issues.jboss.org/browse/", Constants.RELATED_JIRA_PATTERN).size() > 0;
    }

    private List<Issue> getJiraIssuesFromDescription() {
        List<URL> urls = this.extractURLs("https://issues.jboss.org/browse/", Constants.RELATED_JIRA_PATTERN);
        ArrayList<Issue> jiraIssues = new ArrayList<Issue>();
        for (URL url : urls) {
            JiraIssue jiraIssue;
            if (!this.jiraHelper.accepts(url) || (jiraIssue = (JiraIssue)this.jiraHelper.findIssue(url)) == null) continue;
            jiraIssues.add(jiraIssue);
        }
        return jiraIssues;
    }

    private List<URL> extractURLs(String urlBase, Pattern toMatch) {
        ArrayList<URL> urls = new ArrayList<URL>();
        Matcher matcher = toMatch.matcher(this.pullRequest.getBody());
        while (matcher.find()) {
            try {
                urls.add(new URL(urlBase + matcher.group(1)));
            }
            catch (NumberFormatException ignore) {
                System.err.printf("Invalid bug number: %s.\n", ignore);
            }
            catch (MalformedURLException malformed) {
                System.err.printf("Invalid URL formed: %s. \n", malformed);
            }
        }
        return urls;
    }

    public boolean hasBugLinkInDescription() {
        return this.hasBZLinkInDescription() || this.hasJiraLinkInDescription();
    }

    public List<Issue> getIssues() {
        ArrayList<Issue> toReturn = new ArrayList<Issue>(this.bugs.size() + this.jiraIssues.size());
        toReturn.addAll(this.bugs);
        toReturn.addAll(this.jiraIssues);
        return toReturn;
    }

    public boolean hasRelatedPullRequestInDescription() {
        boolean retVal = false;
        if (Constants.RELATED_PR_PATTERN.matcher(this.getGithubDescription()).find()) {
            retVal = true;
        }
        if (Constants.ABBREVIATED_RELATED_PR_PATTERN.matcher(this.getGithubDescription()).find()) {
            retVal = true;
        }
        return retVal;
    }

    public List<RedhatPullRequest> getRelatedPullRequests() {
        if (this.relatedPullRequests != null) {
            return this.relatedPullRequests;
        }
        this.relatedPullRequests = this.getPRFromDescription();
        return this.relatedPullRequests;
    }

    public boolean isUpstreamRequired() {
        return !Constants.UPSTREAM_NOT_REQUIRED.matcher(this.pullRequest.getBody()).find();
    }

    private List<RedhatPullRequest> getPRFromDescription() {
        Matcher matcher = Constants.RELATED_PR_PATTERN.matcher(this.getGithubDescription());
        ArrayList<RedhatPullRequest> relatedPullRequests = new ArrayList<RedhatPullRequest>();
        while (matcher.find()) {
            PullRequest relatedPullRequest = this.ghHelper.getPullRequest(matcher.group(1), matcher.group(2), Integer.valueOf(matcher.group(3)));
            if (relatedPullRequest == null) continue;
            relatedPullRequests.add(new RedhatPullRequest(relatedPullRequest, this.bzHelper, this.jiraHelper, this.ghHelper));
        }
        Matcher abbreviatedMatcher = Constants.ABBREVIATED_RELATED_PR_PATTERN.matcher(this.getGithubDescription());
        while (abbreviatedMatcher.find()) {
            PullRequest relatedPullRequest;
            String match = abbreviatedMatcher.group();
            System.out.println("Match: " + match);
            Matcher abbreviatedExternalMatcher = Constants.ABBREVIATED_RELATED_PR_PATTERN_EXTERNAL_REPO.matcher(match);
            if (abbreviatedExternalMatcher.find()) {
                System.out.println("Attempting External Match: " + match);
                relatedPullRequest = this.ghHelper.getPullRequest(abbreviatedExternalMatcher.group(1), abbreviatedExternalMatcher.group(2), Integer.valueOf(abbreviatedExternalMatcher.group(3)));
                if (relatedPullRequest != null) {
                    System.out.println("External Match Found: " + match);
                    relatedPullRequests.add(new RedhatPullRequest(relatedPullRequest, this.bzHelper, this.jiraHelper, this.ghHelper));
                    continue;
                }
            }
            System.out.println("Attempting Internal Match: " + match);
            relatedPullRequest = this.ghHelper.getPullRequest(this.getOrganization(), this.getRepository(), Integer.valueOf(abbreviatedMatcher.group(2)));
            if (relatedPullRequest == null) continue;
            System.out.println("Internal Match Found: " + match);
            relatedPullRequests.add(new RedhatPullRequest(relatedPullRequest, this.bzHelper, this.jiraHelper, this.ghHelper));
        }
        return relatedPullRequests;
    }

    public int getNumber() {
        return this.pullRequest.getNumber();
    }

    public void postGithubComment(String comment) {
        this.ghHelper.postGithubComment(this.pullRequest, comment);
    }

    public Milestone getMilestone() {
        return this.pullRequest.getMilestone();
    }

    public void setMilestone(Milestone milestone) {
        org.eclipse.egit.github.core.Issue issue = this.ghHelper.getIssue(this.pullRequest);
        issue.setMilestone(milestone);
        this.ghHelper.editIssue(issue);
    }

    public String getTargetBranchTitle() {
        return this.pullRequest.getBase().getRef();
    }

    public String getSourceBranchSha() {
        return this.pullRequest.getHead().getSha();
    }

    public User getGithubUser() {
        return this.pullRequest.getUser();
    }

    public List<Comment> getGithubComments() {
        return this.ghHelper.getComments(this.pullRequest);
    }

    public void postGithubStatus(String targetUrl, String status) {
        this.ghHelper.postGithubStatus(this.pullRequest, targetUrl, status);
    }

    public String getGithubDescription() {
        return this.pullRequest.getBody();
    }

    public Date getGithubUpdatedAt() {
        return this.pullRequest.getUpdatedAt();
    }

    public Comment getLastMatchingGithubComment(Pattern pattern) {
        return this.ghHelper.getLastMatchingComment(this.pullRequest, pattern);
    }

    public String getState() {
        return this.pullRequest.getState();
    }

    public String getHtmlUrl() {
        return this.pullRequest.getHtmlUrl();
    }

    public boolean isMerged() {
        return this.ghHelper.isMerged(this.pullRequest);
    }

    public BuildResult getBuildResult() {
        BuildResult buildResult = BuildResult.UNKNOWN;
        Comment comment = this.ghHelper.getLastMatchingComment(this.pullRequest, Constants.BUILD_OUTCOME);
        if (comment != null) {
            Matcher matcher = Constants.BUILD_OUTCOME.matcher(comment.getBody());
            while (matcher.find()) {
                buildResult = BuildResult.valueOf(matcher.group(2));
            }
        }
        return buildResult;
    }

    public String getOrganization() {
        Matcher matcher = Constants.RELATED_PR_PATTERN.matcher(this.pullRequest.getUrl());
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public String getRepository() {
        Matcher matcher = Constants.RELATED_PR_PATTERN.matcher(this.pullRequest.getUrl());
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }

    public boolean updateStatus(Issue issue, Enum status) throws IllegalArgumentException {
        if (issue instanceof Bug) {
            if (this.bzHelper.accepts(issue.getUrl())) {
                return this.bzHelper.updateStatus(issue.getUrl(), status);
            }
        } else if (issue instanceof JiraIssue) {
            if (this.jiraHelper.accepts(issue.getUrl())) {
                return this.jiraHelper.updateStatus(issue.getUrl(), status);
            }
        } else {
            throw new IllegalArgumentException("Your issue implementation has to be an instance of a Bug or JiraIssue");
        }
        return false;
    }

    public boolean isGithubMilestoneNullOrDefault() {
        return this.pullRequest.getMilestone() == null || this.pullRequest.getMilestone().getTitle().contains("x");
    }

    public List<Label> getGithubLabels() {
        return this.ghHelper.getLabels(this.pullRequest);
    }

    public void addLabel(Label newLabel) {
        this.ghHelper.addLabel(this.pullRequest, newLabel);
    }

    public void removeLabel(Label newLabel) {
        this.ghHelper.removeLabel(this.pullRequest, newLabel);
    }
}

