/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pull.shared.connectors.bugzilla;

import java.net.URL;
import org.jboss.pull.shared.Util;
import org.jboss.pull.shared.connectors.IssueHelper;
import org.jboss.pull.shared.connectors.bugzilla.Bugzilla;
import org.jboss.pull.shared.connectors.common.AbstractCommonIssueHelper;
import org.jboss.pull.shared.connectors.common.Issue;

public class BZHelper
extends AbstractCommonIssueHelper
implements IssueHelper {
    private final String BUGZILLA_LOGIN;
    private final String BUGZILLA_PASSWORD;
    private final Bugzilla bugzillaClient;

    public BZHelper(String configurationFileProperty, String configurationFileDefault) throws Exception {
        super(configurationFileProperty, configurationFileDefault);
        try {
            this.BUGZILLA_LOGIN = Util.require(this.fromUtil, "bugzilla.login");
            this.BUGZILLA_PASSWORD = Util.require(this.fromUtil, "bugzilla.password");
            this.bugzillaClient = new Bugzilla("https://bugzilla.redhat.com/", this.BUGZILLA_LOGIN, this.BUGZILLA_PASSWORD);
        }
        catch (Exception e) {
            System.err.printf("Cannot initialize: %s\n", e);
            e.printStackTrace(System.err);
            throw e;
        }
    }

    @Override
    public Issue findIssue(URL url) throws IllegalArgumentException {
        return this.bugzillaClient.getBug(this.cutIdFromURL(url));
    }

    @Override
    public boolean accepts(URL url) {
        return url.getHost().equalsIgnoreCase("bugzilla.redhat.com");
    }

    @Override
    public boolean updateStatus(URL url, Enum status) {
        throw new UnsupportedOperationException("This feature is not implemented yet.");
    }

    private int cutIdFromURL(URL url) {
        String urlStr = url.toString().trim().toLowerCase();
        int index = urlStr.indexOf("id=");
        return Integer.parseInt(urlStr.substring(index + 3));
    }
}

