/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pull.shared.connectors.bugzilla;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.pull.shared.connectors.common.Flag;
import org.jboss.pull.shared.connectors.common.Issue;

public class Bug
implements Issue {
    private static final long serialVersionUID = 6967220126171894474L;
    public static final Object[] include_fields = new Object[]{"id", "alias", "product", "component", "version", "priority", "severity", "target_milestone", "creator", "assigned_to", "qa_contact", "docs_contact", "status", "resolution", "flags", "groups", "depends_on", "blocks", "target_release", "summary", "description"};
    private int id;
    private List<String> alias;
    private String product;
    private List<String> component;
    private Set<String> version;
    private String priority;
    private String severity;
    private String targetMilestone;
    private String creator;
    private String assignedTo;
    private String qaContact;
    private String docsContact;
    private Status status;
    private String resolution;
    private List<Flag> flags;
    private List<String> groups;
    private Set<Integer> dependsOn;
    private Set<Integer> blocks;
    private Set<String> targetRelease;
    private String summary;
    private String description;
    private URL url;

    public Bug(Map<String, Object> bugMap) {
        Object[] flagObjs;
        this.id = (Integer)bugMap.get("id");
        Object[] aliasObjs = (Object[])bugMap.get("alias");
        this.alias = new ArrayList<String>(aliasObjs.length);
        for (Object obj : aliasObjs) {
            this.alias.add((String)obj);
        }
        this.product = (String)bugMap.get("product");
        Object[] componentObjs = (Object[])bugMap.get("component");
        this.component = new ArrayList<String>(componentObjs.length);
        for (Object obj : componentObjs) {
            this.component.add((String)obj);
        }
        Object[] versionObjs = (Object[])bugMap.get("version");
        this.version = new HashSet<String>(versionObjs.length);
        for (Object obj : versionObjs) {
            this.version.add((String)obj);
        }
        this.priority = (String)bugMap.get("priority");
        this.severity = (String)bugMap.get("severity");
        this.targetMilestone = (String)bugMap.get("target_milestone");
        this.creator = (String)bugMap.get("creator");
        this.assignedTo = (String)bugMap.get("assigned_to");
        this.qaContact = (String)bugMap.get("qa_contact");
        this.docsContact = (String)bugMap.get("docs_contact");
        this.status = Status.valueOf((String)bugMap.get("status"));
        this.resolution = (String)bugMap.get("resolution");
        this.flags = new ArrayList<Flag>();
        for (Object obj : flagObjs = (Object[])bugMap.get("flags")) {
            Flag.Status status;
            Map flag = (Map)obj;
            String name = (String)flag.get("name");
            String setter = (String)flag.get("setter");
            String s = (String)flag.get("status");
            if (s.equals(" ")) {
                status = Flag.Status.UNSET;
            } else if (s.equals("?")) {
                status = Flag.Status.UNKNOWN;
            } else if (s.equals("+")) {
                status = Flag.Status.POSITIVE;
            } else if (s.equals("-")) {
                status = Flag.Status.NEGATIVE;
            } else {
                throw new IllegalStateException("Unknown flag state");
            }
            this.flags.add(new Flag(name, setter, status));
        }
        Object[] groupsObjs = (Object[])bugMap.get("groups");
        this.groups = new ArrayList<String>(groupsObjs.length);
        for (Object obj : groupsObjs) {
            this.groups.add((String)obj);
        }
        Object[] dependsOnObjs = (Object[])bugMap.get("depends_on");
        this.dependsOn = new HashSet<Integer>(dependsOnObjs.length);
        for (Object obj : dependsOnObjs) {
            this.dependsOn.add((Integer)obj);
        }
        Object[] blockObjs = (Object[])bugMap.get("blocks");
        this.blocks = new HashSet<Integer>(blockObjs.length);
        for (Object obj : blockObjs) {
            this.blocks.add((Integer)obj);
        }
        Object[] targetReleaseObjs = (Object[])bugMap.get("target_release");
        this.targetRelease = new HashSet<String>(targetReleaseObjs.length);
        for (Object obj : targetReleaseObjs) {
            this.targetRelease.add((String)obj);
        }
        this.summary = (String)bugMap.get("summary");
        this.description = (String)bugMap.get("description");
        try {
            this.url = new URL("https://bugzilla.redhat.com/show_bug.cgi?id=" + this.id);
        }
        catch (MalformedURLException malformed) {
            System.err.printf("Invalid URL formed: %s. \n", malformed);
        }
    }

    public int getId() {
        return this.id;
    }

    public List<String> getAlias() {
        return this.alias;
    }

    public String getProduct() {
        return this.product;
    }

    public List<String> getComponent() {
        return this.component;
    }

    public Set<String> getVersion() {
        return this.version;
    }

    public String getPriority() {
        return this.priority;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getTargetMilestone() {
        return this.targetMilestone;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getAssignedTo() {
        return this.assignedTo;
    }

    public String getQaContact() {
        return this.qaContact;
    }

    public String getDocsContact() {
        return this.docsContact;
    }

    @Override
    public String getStatus() {
        return this.status.toString();
    }

    public String getResolution() {
        return this.resolution;
    }

    @Override
    public List<Flag> getFlags() {
        return this.flags;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public Set<Integer> getDependsOn() {
        return this.dependsOn;
    }

    public Set<Integer> getBlocks() {
        return this.blocks;
    }

    public Set<String> getTargetRelease() {
        return this.targetRelease;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getNumber() {
        return Integer.toString(this.id);
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public Set<String> getFixVersions() {
        return this.targetRelease;
    }

    public static enum Status {
        NEW,
        ASSIGNED,
        POST,
        MODIFIED,
        ON_DEV,
        ON_QA,
        VERIFIED,
        RELEASE_PENDING,
        CLOSED;

    }
}

