/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pull.shared.connectors.bugzilla;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.jboss.pull.shared.connectors.bugzilla.Bug;
import org.jboss.pull.shared.connectors.common.Flag;

public class Bugzilla {
    private String baseURL;
    private String login;
    private String password;

    public Bugzilla(String serverUrl, String login, String password) {
        this.baseURL = serverUrl;
        this.login = login;
        this.password = password;
    }

    private XmlRpcClient getClient() {
        try {
            String apiURL = this.baseURL + "xmlrpc.cgi";
            XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
            config.setServerURL(new URL(apiURL));
            XmlRpcClient rpcClient = new XmlRpcClient();
            rpcClient.setConfig((XmlRpcClientConfig)config);
            return rpcClient;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Can not get XmlRpcClient from " + this.baseURL);
        }
    }

    private Map<Object, Object> getParameterMap() {
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        params.put("Bugzilla_login", this.login);
        params.put("Bugzilla_password", this.password);
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bug getBug(int bugzillaId) {
        Map<Object, Object> params = this.getParameterMap();
        params.put("include_fields", Bug.include_fields);
        params.put("ids", bugzillaId);
        params.put("permissive", true);
        Object[] objs = new Object[]{params};
        XmlRpcClient rpcClient = this.getClient();
        try {
            Object resultObj = rpcClient.execute("Bug.get", objs);
            Map resultMap = (Map)resultObj;
            Object[] bugs = (Object[])resultMap.get("bugs");
            if (bugs.length == 1) {
                Bug bug;
                Map bugMap = (Map)bugs[0];
                Bug bug2 = bug = new Bug(bugMap);
                return bug2;
            }
            System.out.println("Zero or more than one bug found with id: " + bugzillaId);
        }
        catch (XmlRpcException e) {
            System.err.println("Can not get bug with id : " + bugzillaId);
            e.printStackTrace(System.err);
        }
        finally {
            rpcClient = null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postBugzillaComment(Integer bugzillaId, String comment) {
        Map<Object, Object> params = this.getParameterMap();
        params.put("id", bugzillaId);
        params.put("comment", comment);
        Object[] objs = new Object[]{params};
        XmlRpcClient rpcClient = this.getClient();
        if (rpcClient != null) {
            try {
                rpcClient.execute("Bug.add_comment", objs);
                boolean bl = true;
                return bl;
            }
            catch (XmlRpcException e) {
                e.printStackTrace();
            }
            finally {
                rpcClient = null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateBugzillaStatus(Integer bugzillaId, Bug.Status status) {
        Map<Object, Object> params = this.getParameterMap();
        params.put("ids", bugzillaId);
        params.put("status", (Object)status);
        Object[] objParams = new Object[]{params};
        XmlRpcClient rpcClient = this.getClient();
        try {
            rpcClient.execute("Bug.update", objParams);
            boolean bl = true;
            return bl;
        }
        catch (XmlRpcException e) {
            e.printStackTrace();
        }
        finally {
            rpcClient = null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateBugzillaTargetMilestone(int ids, String taregtMilestone) {
        Map<Object, Object> params = this.getParameterMap();
        params.put("ids", ids);
        params.put("target_milestone", taregtMilestone);
        Object[] objParams = new Object[]{params};
        XmlRpcClient rpcClient = this.getClient();
        try {
            rpcClient.execute("Bug.update", objParams);
            boolean bl = true;
            return bl;
        }
        catch (XmlRpcException e) {
            e.printStackTrace();
        }
        finally {
            rpcClient = null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateBugzillaTargetRelease(int ids, String ... targetRelease) {
        Map<Object, Object> params = this.getParameterMap();
        params.put("ids", ids);
        params.put("target_release", targetRelease);
        Object[] objParams = new Object[]{params};
        XmlRpcClient rpcClient = this.getClient();
        try {
            rpcClient.execute("Bug.update", objParams);
            boolean bl = true;
            return bl;
        }
        catch (XmlRpcException e) {
            e.printStackTrace();
        }
        finally {
            rpcClient = null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateBugzillaFlag(Integer[] ids, String name, Flag.Status status) {
        String flagStatus = status.equals((Object)Flag.Status.POSITIVE) ? "+" : (status.equals((Object)Flag.Status.NEGATIVE) ? "-" : (status.equals((Object)Flag.Status.UNKNOWN) ? "?" : " "));
        Map<Object, Object> params = this.getParameterMap();
        HashMap<String, String> updates = new HashMap<String, String>();
        updates.put("name", name);
        updates.put("status", flagStatus);
        Object[] updateArray = new Object[]{updates};
        params.put("ids", ids);
        params.put("updates", updateArray);
        params.put("permissive", true);
        Object[] objs = new Object[]{params};
        XmlRpcClient rpcClient = this.getClient();
        try {
            rpcClient.execute("Flag.update", objs);
            boolean bl = true;
            return bl;
        }
        catch (XmlRpcException e) {
            e.printStackTrace();
        }
        finally {
            rpcClient = null;
        }
        return false;
    }
}

