/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pull.shared.connectors.github;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.CommitStatus;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.RepositoryBranch;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.CommitService;
import org.eclipse.egit.github.core.service.IssueService;
import org.eclipse.egit.github.core.service.LabelService;
import org.eclipse.egit.github.core.service.MilestoneService;
import org.eclipse.egit.github.core.service.PullRequestService;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.jboss.pull.shared.Util;

public class GithubHelper {
    private final String GITHUB_ORGANIZATION;
    private final String GITHUB_REPO;
    private final String GITHUB_LOGIN;
    private final String GITHUB_TOKEN;
    private final IRepositoryIdProvider repository;
    private final CommitService commitService;
    private final IssueService issueService;
    private final PullRequestService pullRequestService;
    private final MilestoneService milestoneService;
    private final RepositoryService repositoryService;
    private final LabelService labelService;
    List<RepositoryBranch> branches = null;
    private List<Milestone> milestones = null;

    public GithubHelper(String configurationFileProperty, String configurationFileDefault) throws Exception {
        try {
            Properties props = Util.loadProperties(configurationFileProperty, configurationFileDefault);
            this.GITHUB_ORGANIZATION = Util.require(props, "github.organization");
            this.GITHUB_REPO = Util.require(props, "github.repo");
            this.GITHUB_LOGIN = Util.require(props, "github.login");
            this.GITHUB_TOKEN = Util.get(props, "github.token");
            GitHubClient client = new GitHubClient();
            if (this.GITHUB_TOKEN != null && this.GITHUB_TOKEN.length() > 0) {
                client.setOAuth2Token(this.GITHUB_TOKEN);
            }
            this.repository = RepositoryId.create((String)this.GITHUB_ORGANIZATION, (String)this.GITHUB_REPO);
            this.commitService = new CommitService(client);
            this.issueService = new IssueService(client);
            this.pullRequestService = new PullRequestService(client);
            this.milestoneService = new MilestoneService(client);
            this.repositoryService = new RepositoryService(client);
            this.labelService = new LabelService(client);
        }
        catch (Exception e) {
            System.err.printf("Cannot initialize: %s\n", e);
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public List<RepositoryBranch> getBranches() {
        if (this.branches == null) {
            this.branches = new ArrayList<RepositoryBranch>();
            try {
                this.branches = this.repositoryService.getBranches(this.repository);
            }
            catch (IOException e) {
                System.err.println("Error retrieving branches from repository");
                e.printStackTrace();
            }
        }
        return this.branches;
    }

    public PullRequest getPullRequest(int id) {
        return this.getPullRequest(this.repository, id);
    }

    public PullRequest getPullRequest(String upstreamOrganization, String upstreamRepository, int id) {
        return this.getPullRequest((IRepositoryIdProvider)RepositoryId.create((String)upstreamOrganization, (String)upstreamRepository), id);
    }

    private PullRequest getPullRequest(IRepositoryIdProvider repository, int id) {
        PullRequest pullRequest = null;
        try {
            pullRequest = this.pullRequestService.getPullRequest(repository, id);
        }
        catch (IOException e) {
            System.err.printf("Couldn't retrieve PullRequestId: '" + id + "' from Repository: '" + repository.generateId() + "'", new Object[0]);
            e.printStackTrace();
        }
        return pullRequest;
    }

    public List<PullRequest> getPullRequests(String state) {
        ArrayList result;
        try {
            result = this.pullRequestService.getPullRequests(this.repository, state);
        }
        catch (IOException e) {
            System.err.printf("Couldn't get pull requests in state %s of repository %s due to %s.\n", state, this.repository, e);
            result = new ArrayList();
        }
        return result;
    }

    public void postGithubStatus(PullRequest pull, String targetUrl, String status) {
        try {
            CommitStatus commitStatus = new CommitStatus();
            commitStatus.setTargetUrl(targetUrl);
            commitStatus.setState(status);
            this.commitService.createStatus(this.repository, pull.getHead().getSha(), commitStatus);
        }
        catch (Exception e) {
            System.err.printf("Problem posting a status build for sha: %s\n", pull.getHead().getSha());
            e.printStackTrace(System.err);
        }
    }

    public void postGithubComment(PullRequest pull, String comment) {
        try {
            this.issueService.createComment(this.repository, pull.getNumber(), comment);
        }
        catch (IOException e) {
            System.err.printf("Problem posting a comment build for pull: %d\n", pull.getNumber());
            e.printStackTrace(System.err);
        }
    }

    public List<Milestone> getMilestones() {
        if (this.milestones == null) {
            this.milestones = new ArrayList<Milestone>();
            try {
                this.milestones = this.milestoneService.getMilestones(this.repository, "open");
                this.milestones.addAll(this.milestoneService.getMilestones(this.repository, "closed"));
            }
            catch (IOException e) {
                System.err.printf("Problem getting milestones", new Object[0]);
                e.printStackTrace(System.err);
            }
        }
        return this.milestones;
    }

    public Milestone createMilestone(String title) {
        Milestone newMilestone = new Milestone();
        newMilestone.setTitle(title);
        Milestone returnMilestone = null;
        try {
            returnMilestone = this.milestoneService.createMilestone(this.repository, newMilestone);
        }
        catch (IOException e) {
            System.err.printf("Problem creating new milestone. title: " + title, new Object[0]);
            e.printStackTrace(System.err);
        }
        return returnMilestone;
    }

    public Issue getIssue(PullRequest pullRequest) {
        int id = this.getIssueIdFromIssueURL(pullRequest.getIssueUrl());
        Issue issue = null;
        try {
            issue = this.issueService.getIssue(this.repository, id);
        }
        catch (IOException e) {
            System.err.printf("Problem getting issue. id: " + id, new Object[0]);
            e.printStackTrace(System.err);
        }
        return issue;
    }

    private int getIssueIdFromIssueURL(String issueURL) {
        return Integer.valueOf(issueURL.substring(issueURL.lastIndexOf("/") + 1));
    }

    public Issue editIssue(Issue issue) {
        Issue returnIssue = null;
        try {
            returnIssue = this.issueService.editIssue(this.repository, issue);
        }
        catch (IOException e) {
            System.err.printf("Problem editing issue. id: " + issue.getId(), new Object[0]);
            e.printStackTrace(System.err);
        }
        return returnIssue;
    }

    public String getGithubLogin() {
        return this.GITHUB_LOGIN;
    }

    public boolean isMerged(PullRequest pullRequest) {
        if (pullRequest == null) {
            return false;
        }
        if (!pullRequest.getState().equals("closed")) {
            return false;
        }
        try {
            if (this.pullRequestService.isMerged((IRepositoryIdProvider)pullRequest.getBase().getRepo(), pullRequest.getNumber())) {
                return true;
            }
        }
        catch (IOException ignore) {
            System.err.printf("Cannot get Merged information of the pull request %d: %s.\n", pullRequest.getNumber(), ignore);
            ignore.printStackTrace(System.err);
        }
        try {
            List comments = this.issueService.getComments((IRepositoryIdProvider)pullRequest.getBase().getRepo(), pullRequest.getNumber());
            for (Comment comment : comments) {
                if (comment.getBody().toLowerCase().indexOf("merged") == -1) continue;
                return true;
            }
        }
        catch (IOException ignore) {
            System.err.printf("Cannot get comments of the pull request %d: %s.\n", pullRequest.getNumber(), ignore);
            ignore.printStackTrace(System.err);
        }
        return false;
    }

    public Comment getLastMatchingComment(PullRequest pullRequest, Pattern pattern) {
        Comment lastComment = null;
        List<Comment> comments = this.getComments(pullRequest);
        for (Comment comment : comments) {
            Matcher matcher = pattern.matcher(comment.getBody());
            if (!matcher.find()) continue;
            lastComment = comment;
        }
        return lastComment;
    }

    public List<Comment> getComments(PullRequest pullRequest) {
        try {
            return this.issueService.getComments(this.repository, pullRequest.getNumber());
        }
        catch (IOException e) {
            System.err.println("Error to get comments for pull request : " + pullRequest.getNumber());
            e.printStackTrace(System.err);
            return new ArrayList<Comment>();
        }
    }

    public List<Label> getLabels(PullRequest pullRequest) {
        Issue issue = this.getIssue(pullRequest);
        if (issue != null) {
            return issue.getLabels();
        }
        return new ArrayList<Label>();
    }

    public Label getLabel(String title) {
        try {
            return this.labelService.getLabel(this.repository, title);
        }
        catch (IOException e) {
            System.err.println("Error trying to get label '" + title + "'");
            return null;
        }
    }

    public void addLabel(PullRequest pullRequest, Label label) {
        Issue issue = this.getIssue(pullRequest);
        List labels = issue.getLabels();
        labels.add(label);
        issue.setLabels(labels);
        this.editIssue(issue);
    }

    public void removeLabel(PullRequest pullRequest, Label newLabel) {
        Issue issue = this.getIssue(pullRequest);
        List labels = issue.getLabels();
        for (Label label : issue.getLabels()) {
            if (!label.getName().equals(newLabel.getName())) continue;
            labels.remove(label);
            break;
        }
        issue.setLabels(labels);
        this.editIssue(issue);
    }
}

