/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pull.shared.connectors.jira;

import com.atlassian.jira.rest.client.JiraRestClient;
import com.atlassian.jira.rest.client.NullProgressMonitor;
import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.internal.jersey.JerseyJiraRestClientFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.pull.shared.Util;
import org.jboss.pull.shared.connectors.IssueHelper;
import org.jboss.pull.shared.connectors.common.AbstractCommonIssueHelper;
import org.jboss.pull.shared.connectors.jira.JiraIssue;

public class JiraHelper
extends AbstractCommonIssueHelper
implements IssueHelper {
    private static String JIRA_LOGIN;
    private static String JIRA_PASSWORD;
    private JiraRestClient restClient;

    public JiraHelper(String configurationFileProperty, String configurationFileDefault) throws Exception {
        super(configurationFileProperty, configurationFileDefault);
        try {
            JIRA_LOGIN = Util.require(this.fromUtil, "jira.login");
            JIRA_PASSWORD = Util.require(this.fromUtil, "jira.password");
            this.restClient = this.buildJiraRestClient();
        }
        catch (Exception e) {
            System.err.printf("Cannot initialize: %s\n", e);
            e.printStackTrace(System.err);
            throw e;
        }
    }

    @Override
    public org.jboss.pull.shared.connectors.common.Issue findIssue(URL url) throws IllegalArgumentException {
        String key = this.cutKeyFromURL(url);
        Issue fromServer = this.restClient.getIssueClient().getIssue(key, (ProgressMonitor)new NullProgressMonitor());
        return new JiraIssue(fromServer);
    }

    @Override
    public boolean accepts(URL url) {
        return url.getHost().equalsIgnoreCase("issues.jboss.org");
    }

    @Override
    public boolean updateStatus(URL url, Enum status) {
        throw new UnsupportedOperationException("This feature is not supported or tested yet.");
    }

    private JiraRestClient buildJiraRestClient() throws URISyntaxException {
        JerseyJiraRestClientFactory clientFactory = new JerseyJiraRestClientFactory();
        return clientFactory.createWithBasicHttpAuthentication(new URI("https://issues.jboss.org"), JIRA_LOGIN, JIRA_PASSWORD);
    }

    private String cutKeyFromURL(URL url) {
        String urlString = url.toString();
        int browse = urlString.indexOf("browse/");
        int slashAfterBrowse = urlString.indexOf("/", browse);
        return urlString.substring(slashAfterBrowse + 1);
    }
}

