/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pull.shared.connectors.jira;

import com.atlassian.jira.rest.client.domain.Field;
import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.domain.Version;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.pull.shared.connectors.common.Flag;

public class JiraIssue
implements org.jboss.pull.shared.connectors.common.Issue {
    private URL url;
    private static final long serialVersionUID = 7228344342017879011L;
    private String id;
    private IssueStatus status;
    private String resolution;
    private String targetRelease;
    private List<Flag> flags;
    private Set<String> fixVersions;

    public JiraIssue(Issue issue) {
        this.id = issue.getKey();
        String statusString = issue.getStatus().getName().toUpperCase();
        statusString = statusString.replace(" ", "_");
        this.status = IssueStatus.valueOf(statusString);
        this.resolution = issue.getResolution() != null ? issue.getResolution().getName().toUpperCase() : "UNRESOLVED";
        Field releaseField = issue.getFieldByName("Target Release");
        if (releaseField != null) {
            if (releaseField.getValue() != null) {
                this.targetRelease = this.cutTargetReleaseString(releaseField.getValue().toString());
            }
        } else {
            this.targetRelease = "UNSET";
        }
        this.flags = new ArrayList<Flag>(6);
        this.flags.add(this.buildFlagFromField(issue.getFieldByName("CDW release")));
        this.flags.add(this.buildFlagFromField(issue.getFieldByName("CDW pm_ack")));
        this.flags.add(this.buildFlagFromField(issue.getFieldByName("CDW devel_ack")));
        this.flags.add(this.buildFlagFromField(issue.getFieldByName("CDW qa_ack")));
        this.flags.add(this.buildFlagFromField(issue.getFieldByName("CDW blocker")));
        this.flags.add(this.buildFlagFromField(issue.getFieldByName("CDW exception")));
        this.fixVersions = this.findFixVersions(issue.getFixVersions());
        try {
            this.url = new URL("https://issues.jboss.org/browse/" + this.id);
        }
        catch (MalformedURLException malformed) {
            System.err.printf("Invalid URL formed: %s. \n", malformed);
        }
    }

    @Override
    public String getNumber() {
        return this.id;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public String getStatus() {
        return this.status.toString();
    }

    @Override
    public List<Flag> getFlags() {
        return this.flags;
    }

    @Override
    public Set<String> getFixVersions() {
        return this.fixVersions;
    }

    public String getResolution() {
        return this.resolution;
    }

    public String getTargetRelease() {
        return this.targetRelease;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("\n[id=" + this.id + "]");
        builder.append("\n[status=" + (Object)((Object)this.status) + "]");
        builder.append("\n[resolution=" + this.resolution + "]");
        builder.append("\n[targetRelease=" + this.targetRelease + "]");
        if (this.flags != null) {
            builder.append("\n[flags=");
            for (Flag f : this.flags) {
                if (f.getStatus().equals((Object)Flag.Status.UNKNOWN)) continue;
                builder.append(" " + f.toString() + ",");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append("]");
        }
        builder.append("\n[fixVersions=");
        for (String s : this.fixVersions) {
            builder.append("(" + s + "),");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("]");
        builder.append("\n}");
        return builder.toString();
    }

    private Flag buildFlagFromField(Field field) {
        String name = field.getName();
        String statusValue = (String)field.getValue();
        Flag.Status status = statusValue == null ? Flag.Status.UNKNOWN : (statusValue.equals("+") ? Flag.Status.POSITIVE : (statusValue.equals("-") ? Flag.Status.NEGATIVE : (statusValue.equals("?") ? Flag.Status.UNSET : Flag.Status.UNKNOWN)));
        return new Flag(name, "{UNKNOWN_SETTER}", status);
    }

    private Set<String> findFixVersions(Iterable<Version> fixVersions) {
        TreeSet<String> toReturn = new TreeSet<String>();
        for (Version v : fixVersions) {
            toReturn.add(v.getName());
        }
        return toReturn;
    }

    private String cutTargetReleaseString(String releaseValue) {
        int descriptionStart = releaseValue.indexOf("description");
        int colonPosition = releaseValue.indexOf(":", descriptionStart);
        int commaSeparator = releaseValue.indexOf(",", colonPosition);
        String retVal = releaseValue.substring(colonPosition + 1, commaSeparator);
        return retVal.substring(1, retVal.length() - 1);
    }

    public static enum IssueStatus {
        NEW,
        CODING_IN_PROGRESS,
        OPEN,
        RESOLVED,
        READY_FOR_QA,
        PULL_REQUEST_SENT,
        QA_IN_PROGRESS,
        VERIFIED,
        REOPENED,
        CLOSED,
        UNKNOWN;

    }
}

