/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pull.shared.evaluators;

import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.pull.shared.PullHelper;
import org.jboss.pull.shared.Util;
import org.jboss.pull.shared.connectors.RedhatPullRequest;
import org.jboss.pull.shared.connectors.bugzilla.Bug;
import org.jboss.pull.shared.connectors.common.Flag;
import org.jboss.pull.shared.connectors.common.Issue;
import org.jboss.pull.shared.evaluators.BasePullEvaluator;
import org.jboss.pull.shared.spi.PullEvaluator;

public class BugAndJiraFlagBasedPullEvaluator
extends BasePullEvaluator {
    public static final String REQUIRED_FLAGS_PROPERTY = "required.flags";
    public static final String PM_ACK = "pm_ack";
    public static final String QA_ACK = "qa_ack";
    public static final String DEVEL_ACK = "devel_ack";
    protected final Set<String> REQUIRED_FLAGS = new HashSet<String>();

    @Override
    public void init(PullHelper helper, Properties configuration, String version) {
        super.init(helper, configuration, version);
        this.REQUIRED_FLAGS.add(PM_ACK);
        this.REQUIRED_FLAGS.add(DEVEL_ACK);
        this.REQUIRED_FLAGS.add(QA_ACK);
        String requiredFlags = Util.require(configuration, version + "." + REQUIRED_FLAGS_PROPERTY);
        StringTokenizer tokenizer = new StringTokenizer(requiredFlags, ", ");
        while (tokenizer.hasMoreTokens()) {
            String requiredFlag = tokenizer.nextToken();
            this.REQUIRED_FLAGS.add(requiredFlag);
        }
    }

    @Override
    public PullEvaluator.Result isMergeable(RedhatPullRequest pull) {
        PullEvaluator.Result mergeable = this.isMergeableByUpstream(pull);
        mergeable.and(this.isMergeableByBugzilla(pull));
        return mergeable;
    }

    protected PullEvaluator.Result isMergeableByBugzilla(RedhatPullRequest pull) {
        PullEvaluator.Result mergeable = new PullEvaluator.Result(true);
        List<? extends Issue> bugs = this.getIssue(pull);
        if (bugs.isEmpty()) {
            mergeable.setMergeable(false);
            mergeable.addDescription("- Missing any bugzilla bug");
            return mergeable;
        }
        for (Bug bug : bugs) {
            HashSet<String> flagsToCheck = new HashSet<String>(this.REQUIRED_FLAGS);
            List<Flag> flags = bug.getFlags();
            for (Flag flag : flags) {
                if (flag.getStatus() != Flag.Status.POSITIVE) continue;
                flagsToCheck.remove(flag.getName());
            }
            if (flagsToCheck.isEmpty()) continue;
            mergeable.setMergeable(false);
            mergeable.addDescription(this.missingFlagsDescription(bug, flagsToCheck));
        }
        if (mergeable.isMergeable()) {
            mergeable.addDescription("+ Bugzilla is OK");
        }
        return mergeable;
    }

    private String missingFlagsDescription(Bug bug, Set<String> missingFlags) {
        StringBuilder description = new StringBuilder("- Bug bz").append(bug.getNumber()).append(" is missing flags");
        String delim = " ";
        for (String missingFlag : missingFlags) {
            description.append(delim).append(missingFlag);
            delim = ", ";
        }
        return description.toString();
    }
}

