/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.commons;

import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.commons.SignatureRemapper;
import org.jruby.org.objectweb.asm.signature.SignatureReader;
import org.jruby.org.objectweb.asm.signature.SignatureVisitor;
import org.jruby.org.objectweb.asm.signature.SignatureWriter;

public abstract class Remapper {
    public String mapDesc(String desc) {
        Type t = Type.getType(desc);
        switch (t.getSort()) {
            case 9: {
                String s2 = this.mapDesc(t.getElementType().getDescriptor());
                for (int i2 = 0; i2 < t.getDimensions(); ++i2) {
                    s2 = '[' + s2;
                }
                return s2;
            }
            case 10: {
                String newType = this.map(t.getInternalName());
                if (newType == null) break;
                return 'L' + newType + ';';
            }
        }
        return desc;
    }

    private Type mapType(Type t) {
        switch (t.getSort()) {
            case 9: {
                String s2 = this.mapDesc(t.getElementType().getDescriptor());
                for (int i2 = 0; i2 < t.getDimensions(); ++i2) {
                    s2 = '[' + s2;
                }
                return Type.getType(s2);
            }
            case 10: {
                String s3 = this.map(t.getInternalName());
                return s3 != null ? Type.getObjectType(s3) : t;
            }
            case 11: {
                return Type.getMethodType(this.mapMethodDesc(t.getDescriptor()));
            }
        }
        return t;
    }

    public String mapType(String type2) {
        if (type2 == null) {
            return null;
        }
        return this.mapType(Type.getObjectType(type2)).getInternalName();
    }

    public String[] mapTypes(String[] types) {
        String[] newTypes = null;
        boolean needMapping = false;
        for (int i2 = 0; i2 < types.length; ++i2) {
            String type2 = types[i2];
            String newType = this.map(type2);
            if (newType != null && newTypes == null) {
                newTypes = new String[types.length];
                if (i2 > 0) {
                    System.arraycopy(types, 0, newTypes, 0, i2);
                }
                needMapping = true;
            }
            if (!needMapping) continue;
            newTypes[i2] = newType == null ? type2 : newType;
        }
        return needMapping ? newTypes : types;
    }

    public String mapMethodDesc(String desc) {
        if ("()V".equals(desc)) {
            return desc;
        }
        Type[] args2 = Type.getArgumentTypes(desc);
        StringBuilder sb = new StringBuilder("(");
        for (int i2 = 0; i2 < args2.length; ++i2) {
            sb.append(this.mapDesc(args2[i2].getDescriptor()));
        }
        Type returnType = Type.getReturnType(desc);
        if (returnType == Type.VOID_TYPE) {
            sb.append(")V");
            return sb.toString();
        }
        sb.append(')').append(this.mapDesc(returnType.getDescriptor()));
        return sb.toString();
    }

    public Object mapValue(Object value2) {
        if (value2 instanceof Type) {
            return this.mapType((Type)value2);
        }
        if (value2 instanceof Handle) {
            Handle h = (Handle)value2;
            return new Handle(h.getTag(), this.mapType(h.getOwner()), this.mapMethodName(h.getOwner(), h.getName(), h.getDesc()), this.mapMethodDesc(h.getDesc()), h.isInterface());
        }
        return value2;
    }

    public String mapSignature(String signature, boolean typeSignature) {
        if (signature == null) {
            return null;
        }
        SignatureReader r = new SignatureReader(signature);
        SignatureWriter w = new SignatureWriter();
        SignatureVisitor a = this.createSignatureRemapper(w);
        if (typeSignature) {
            r.acceptType(a);
        } else {
            r.accept(a);
        }
        return w.toString();
    }

    @Deprecated
    protected SignatureVisitor createRemappingSignatureAdapter(SignatureVisitor v) {
        return new SignatureRemapper(v, this);
    }

    protected SignatureVisitor createSignatureRemapper(SignatureVisitor v) {
        return this.createRemappingSignatureAdapter(v);
    }

    public String mapMethodName(String owner2, String name2, String desc) {
        return name2;
    }

    public String mapInvokeDynamicMethodName(String name2, String desc) {
        return name2;
    }

    public String mapFieldName(String owner2, String name2, String desc) {
        return name2;
    }

    public String mapPackageName(String name2) {
        int index2;
        String fakeName = this.map(name2 + ".FakeClassName");
        return fakeName == null || (index2 = fakeName.lastIndexOf(46)) == -1 ? name2 : fakeName.substring(0, index2);
    }

    public String mapModuleName(String name2) {
        return name2;
    }

    public String map(String typeName) {
        return typeName;
    }
}

