/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import javaemul.internal.ArrayHelper;
import javaemul.internal.InternalPreconditions;

public final class Array {
    public static Object get(Object array, int index) {
        if (array instanceof boolean[]) {
            return Array.getBooleanImpl(array, index);
        }
        if (array instanceof byte[]) {
            return Array.getByteImpl(array, index);
        }
        if (array instanceof char[]) {
            return Character.valueOf(Array.getCharImpl(array, index));
        }
        if (array instanceof double[]) {
            return Array.getDoubleImpl(array, index);
        }
        if (array instanceof float[]) {
            return Float.valueOf(Array.getFloatImpl(array, index));
        }
        if (array instanceof int[]) {
            return Array.getIntImpl(array, index);
        }
        if (array instanceof long[]) {
            return Array.getLongImpl(array, index);
        }
        if (array instanceof short[]) {
            return Array.getShortImpl(array, index);
        }
        InternalPreconditions.checkArgument(array instanceof Object[]);
        Object[] typedArray = (Object[])array;
        return typedArray[index];
    }

    public static boolean getBoolean(Object array, int index) {
        InternalPreconditions.checkArgument(array instanceof boolean[]);
        return Array.getBooleanImpl(array, index);
    }

    private static boolean getBooleanImpl(Object array, int index) {
        boolean[] typedArray = (boolean[])array;
        return typedArray[index];
    }

    public static byte getByte(Object array, int index) {
        InternalPreconditions.checkArgument(array instanceof byte[]);
        return Array.getByteImpl(array, index);
    }

    private static byte getByteImpl(Object array, int index) {
        byte[] typedArray = (byte[])array;
        return typedArray[index];
    }

    public static char getChar(Object array, int index) {
        InternalPreconditions.checkArgument(array instanceof char[]);
        return Array.getCharImpl(array, index);
    }

    private static char getCharImpl(Object array, int index) {
        char[] typedArray = (char[])array;
        return typedArray[index];
    }

    public static double getDouble(Object array, int index) {
        if (array instanceof double[]) {
            return Array.getDoubleImpl(array, index);
        }
        if (array instanceof byte[]) {
            return Array.getByteImpl(array, index);
        }
        if (array instanceof char[]) {
            return Array.getCharImpl(array, index);
        }
        if (array instanceof float[]) {
            return Array.getFloatImpl(array, index);
        }
        if (array instanceof int[]) {
            return Array.getIntImpl(array, index);
        }
        if (array instanceof long[]) {
            return Array.getLongImpl(array, index);
        }
        if (array instanceof short[]) {
            return Array.getShortImpl(array, index);
        }
        InternalPreconditions.checkArgument(false);
        return 0.0;
    }

    private static double getDoubleImpl(Object array, int index) {
        double[] typedArray = (double[])array;
        return typedArray[index];
    }

    public static float getFloat(Object array, int index) {
        if (array instanceof float[]) {
            return Array.getFloatImpl(array, index);
        }
        if (array instanceof byte[]) {
            return Array.getByteImpl(array, index);
        }
        if (array instanceof char[]) {
            return Array.getCharImpl(array, index);
        }
        if (array instanceof int[]) {
            return Array.getIntImpl(array, index);
        }
        if (array instanceof long[]) {
            return Array.getLongImpl(array, index);
        }
        if (array instanceof short[]) {
            return Array.getShortImpl(array, index);
        }
        InternalPreconditions.checkArgument(false);
        return 0.0f;
    }

    private static float getFloatImpl(Object array, int index) {
        float[] typedArray = (float[])array;
        return typedArray[index];
    }

    public static int getInt(Object array, int index) {
        if (array instanceof int[]) {
            return Array.getIntImpl(array, index);
        }
        if (array instanceof byte[]) {
            return Array.getByteImpl(array, index);
        }
        if (array instanceof char[]) {
            return Array.getCharImpl(array, index);
        }
        if (array instanceof short[]) {
            return Array.getShortImpl(array, index);
        }
        InternalPreconditions.checkArgument(false);
        return 0;
    }

    private static int getIntImpl(Object array, int index) {
        int[] typedArray = (int[])array;
        return typedArray[index];
    }

    public static int getLength(Object array) {
        InternalPreconditions.checkNotNull(array);
        return ArrayHelper.getLength(array);
    }

    public static long getLong(Object array, int index) {
        if (array instanceof long[]) {
            return Array.getLongImpl(array, index);
        }
        if (array instanceof byte[]) {
            return Array.getByteImpl(array, index);
        }
        if (array instanceof char[]) {
            return Array.getCharImpl(array, index);
        }
        if (array instanceof int[]) {
            return Array.getIntImpl(array, index);
        }
        if (array instanceof short[]) {
            return Array.getShortImpl(array, index);
        }
        InternalPreconditions.checkArgument(false);
        return 0L;
    }

    private static long getLongImpl(Object array, int index) {
        long[] typedArray = (long[])array;
        return typedArray[index];
    }

    public static short getShort(Object array, int index) {
        if (array instanceof short[]) {
            return Array.getShortImpl(array, index);
        }
        if (array instanceof byte[]) {
            return Array.getByteImpl(array, index);
        }
        InternalPreconditions.checkArgument(false);
        return 0;
    }

    private static short getShortImpl(Object array, int index) {
        short[] typedArray = (short[])array;
        return typedArray[index];
    }

    public static void set(Object array, int index, Object value) {
        if (array instanceof Object[]) {
            Object[] typedArray = (Object[])array;
            typedArray[index] = value;
        } else if (value instanceof Boolean) {
            Array.setBoolean(array, index, (Boolean)value);
        } else if (value instanceof Byte) {
            Array.setByte(array, index, (Byte)value);
        } else if (value instanceof Character) {
            Array.setChar(array, index, ((Character)value).charValue());
        } else if (value instanceof Short) {
            Array.setShort(array, index, (Short)value);
        } else if (value instanceof Integer) {
            Array.setInt(array, index, (Integer)value);
        } else if (value instanceof Long) {
            Array.setLong(array, index, (Long)value);
        } else if (value instanceof Float) {
            Array.setFloat(array, index, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            Array.setDouble(array, index, (Double)value);
        } else {
            InternalPreconditions.checkArgument(false);
        }
    }

    public static void setBoolean(Object array, int index, boolean value) {
        InternalPreconditions.checkArgument(array instanceof boolean[]);
        Array.setBooleanImpl(array, index, value);
    }

    private static void setBooleanImpl(Object array, int index, boolean value) {
        boolean[] typedArray = (boolean[])array;
        typedArray[index] = value;
    }

    public static void setByte(Object array, int index, byte value) {
        if (array instanceof byte[]) {
            Array.setByteImpl(array, index, value);
        } else if (array instanceof double[]) {
            Array.setDoubleImpl(array, index, value);
        } else if (array instanceof float[]) {
            Array.setFloatImpl(array, index, value);
        } else if (array instanceof int[]) {
            Array.setIntImpl(array, index, value);
        } else if (array instanceof long[]) {
            Array.setLongImpl(array, index, value);
        } else if (array instanceof short[]) {
            Array.setShortImpl(array, index, value);
        } else {
            InternalPreconditions.checkArgument(false);
        }
    }

    private static void setByteImpl(Object array, int index, byte value) {
        byte[] typedArray = (byte[])array;
        typedArray[index] = value;
    }

    public static void setChar(Object array, int index, char value) {
        if (array instanceof char[]) {
            Array.setCharImpl(array, index, value);
        } else if (array instanceof double[]) {
            Array.setDoubleImpl(array, index, value);
        } else if (array instanceof float[]) {
            Array.setFloatImpl(array, index, value);
        } else if (array instanceof int[]) {
            Array.setIntImpl(array, index, value);
        } else if (array instanceof long[]) {
            Array.setLongImpl(array, index, value);
        } else {
            InternalPreconditions.checkArgument(false);
        }
    }

    private static void setCharImpl(Object array, int index, char value) {
        char[] typedArray = (char[])array;
        typedArray[index] = value;
    }

    public static void setDouble(Object array, int index, double value) {
        InternalPreconditions.checkArgument(array instanceof double[]);
        Array.setDoubleImpl(array, index, value);
    }

    private static void setDoubleImpl(Object array, int index, double value) {
        double[] typedArray = (double[])array;
        typedArray[index] = value;
    }

    public static void setFloat(Object array, int index, float value) {
        if (array instanceof float[]) {
            Array.setFloatImpl(array, index, value);
        } else if (array instanceof double[]) {
            Array.setDoubleImpl(array, index, value);
        } else {
            InternalPreconditions.checkArgument(false);
        }
    }

    private static void setFloatImpl(Object array, int index, float value) {
        float[] typedArray = (float[])array;
        typedArray[index] = value;
    }

    public static void setInt(Object array, int index, int value) {
        if (array instanceof int[]) {
            Array.setIntImpl(array, index, value);
        } else if (array instanceof double[]) {
            Array.setDoubleImpl(array, index, value);
        } else if (array instanceof float[]) {
            Array.setFloatImpl(array, index, value);
        } else if (array instanceof long[]) {
            Array.setLongImpl(array, index, value);
        } else {
            InternalPreconditions.checkArgument(false);
        }
    }

    private static void setIntImpl(Object array, int index, int value) {
        int[] typedArray = (int[])array;
        typedArray[index] = value;
    }

    public static void setLong(Object array, int index, long value) {
        if (array instanceof long[]) {
            Array.setLongImpl(array, index, value);
        } else if (array instanceof double[]) {
            Array.setDoubleImpl(array, index, value);
        } else if (array instanceof float[]) {
            Array.setFloatImpl(array, index, value);
        } else {
            InternalPreconditions.checkArgument(false);
        }
    }

    private static void setLongImpl(Object array, int index, long value) {
        long[] typedArray = (long[])array;
        typedArray[index] = value;
    }

    public static void setShort(Object array, int index, short value) {
        if (array instanceof short[]) {
            Array.setShortImpl(array, index, value);
        } else if (array instanceof double[]) {
            Array.setDoubleImpl(array, index, value);
        } else if (array instanceof float[]) {
            Array.setFloatImpl(array, index, value);
        } else if (array instanceof int[]) {
            Array.setIntImpl(array, index, value);
        } else if (array instanceof long[]) {
            Array.setLongImpl(array, index, value);
        } else {
            InternalPreconditions.checkArgument(false);
        }
    }

    private static void setShortImpl(Object array, int index, short value) {
        short[] typedArray = (short[])array;
        typedArray[index] = value;
    }

    private Array() {
    }
}

