/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;

class Logical {
    static BigInteger and(BigInteger val, BigInteger that) {
        if (that.sign == 0 || val.sign == 0) {
            return BigInteger.ZERO;
        }
        if (that.equals(BigInteger.MINUS_ONE)) {
            return val;
        }
        if (val.equals(BigInteger.MINUS_ONE)) {
            return that;
        }
        if (val.sign > 0) {
            if (that.sign > 0) {
                return Logical.andPositive(val, that);
            }
            return Logical.andDiffSigns(val, that);
        }
        if (that.sign > 0) {
            return Logical.andDiffSigns(that, val);
        }
        if (val.numberLength > that.numberLength) {
            return Logical.andNegative(val, that);
        }
        return Logical.andNegative(that, val);
    }

    static BigInteger andDiffSigns(BigInteger positive, BigInteger negative) {
        int iPos = positive.getFirstNonzeroDigit();
        int iNeg = negative.getFirstNonzeroDigit();
        if (iNeg >= positive.numberLength) {
            return BigInteger.ZERO;
        }
        int resLength = positive.numberLength;
        int[] resDigits = new int[resLength];
        int i = Math.max(iPos, iNeg);
        if (i == iNeg) {
            resDigits[i] = -negative.digits[i] & positive.digits[i];
            ++i;
        }
        int limit = Math.min(negative.numberLength, positive.numberLength);
        while (i < limit) {
            resDigits[i] = ~negative.digits[i] & positive.digits[i];
            ++i;
        }
        if (i >= negative.numberLength) {
            while (i < positive.numberLength) {
                resDigits[i] = positive.digits[i];
                ++i;
            }
        }
        BigInteger result = new BigInteger(1, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static BigInteger andNegative(BigInteger longer, BigInteger shorter) {
        int iLonger = longer.getFirstNonzeroDigit();
        int iShorter = shorter.getFirstNonzeroDigit();
        if (iLonger >= shorter.numberLength) {
            return longer;
        }
        int i = Math.max(iShorter, iLonger);
        int digit = iShorter > iLonger ? -shorter.digits[i] & ~longer.digits[i] : (iShorter < iLonger ? ~shorter.digits[i] & -longer.digits[i] : -shorter.digits[i] & -longer.digits[i]);
        if (digit == 0) {
            ++i;
            while (i < shorter.numberLength && (digit = ~(longer.digits[i] | shorter.digits[i])) == 0) {
                ++i;
            }
            if (digit == 0) {
                while (i < longer.numberLength && (digit = ~longer.digits[i]) == 0) {
                    ++i;
                }
                if (digit == 0) {
                    int resLength = longer.numberLength + 1;
                    int[] resDigits = new int[resLength];
                    resDigits[resLength - 1] = 1;
                    BigInteger result = new BigInteger(-1, resLength, resDigits);
                    return result;
                }
            }
        }
        int resLength = longer.numberLength;
        int[] resDigits = new int[resLength];
        resDigits[i] = -digit;
        ++i;
        while (i < shorter.numberLength) {
            resDigits[i] = longer.digits[i] | shorter.digits[i];
            ++i;
        }
        while (i < longer.numberLength) {
            resDigits[i] = longer.digits[i];
            ++i;
        }
        BigInteger result = new BigInteger(-1, resLength, resDigits);
        return result;
    }

    static BigInteger andNot(BigInteger val, BigInteger that) {
        if (that.sign == 0) {
            return val;
        }
        if (val.sign == 0) {
            return BigInteger.ZERO;
        }
        if (val.equals(BigInteger.MINUS_ONE)) {
            return that.not();
        }
        if (that.equals(BigInteger.MINUS_ONE)) {
            return BigInteger.ZERO;
        }
        if (val.sign > 0) {
            if (that.sign > 0) {
                return Logical.andNotPositive(val, that);
            }
            return Logical.andNotPositiveNegative(val, that);
        }
        if (that.sign > 0) {
            return Logical.andNotNegativePositive(val, that);
        }
        return Logical.andNotNegative(val, that);
    }

    static BigInteger andNotNegative(BigInteger val, BigInteger that) {
        int limit;
        int iVal = val.getFirstNonzeroDigit();
        int iThat = that.getFirstNonzeroDigit();
        if (iVal >= that.numberLength) {
            return BigInteger.ZERO;
        }
        int resLength = that.numberLength;
        int[] resDigits = new int[resLength];
        int i = iVal;
        if (iVal < iThat) {
            resDigits[i] = -val.digits[i];
            limit = Math.min(val.numberLength, iThat);
            ++i;
            while (i < limit) {
                resDigits[i] = ~val.digits[i];
                ++i;
            }
            if (i == val.numberLength) {
                while (i < iThat) {
                    resDigits[i] = -1;
                    ++i;
                }
                resDigits[i] = that.digits[i] - 1;
            } else {
                resDigits[i] = ~val.digits[i] & that.digits[i] - 1;
            }
        } else {
            resDigits[i] = iThat < iVal ? -val.digits[i] & that.digits[i] : -val.digits[i] & that.digits[i] - 1;
        }
        limit = Math.min(val.numberLength, that.numberLength);
        ++i;
        while (i < limit) {
            resDigits[i] = ~val.digits[i] & that.digits[i];
            ++i;
        }
        while (i < that.numberLength) {
            resDigits[i] = that.digits[i];
            ++i;
        }
        BigInteger result = new BigInteger(1, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static BigInteger andNotNegativePositive(BigInteger negative, BigInteger positive) {
        int i;
        int limit;
        int[] resDigits;
        int iNeg = negative.getFirstNonzeroDigit();
        int iPos = positive.getFirstNonzeroDigit();
        if (iNeg >= positive.numberLength) {
            return negative;
        }
        int resLength = Math.max(negative.numberLength, positive.numberLength);
        if (iPos > iNeg) {
            resDigits = new int[resLength];
            limit = Math.min(negative.numberLength, iPos);
            for (i = iNeg; i < limit; ++i) {
                resDigits[i] = negative.digits[i];
            }
            if (i == negative.numberLength) {
                for (i = iPos; i < positive.numberLength; ++i) {
                    resDigits[i] = positive.digits[i];
                }
            }
        } else {
            int digit = -negative.digits[i] & ~positive.digits[i];
            if (digit == 0) {
                limit = Math.min(positive.numberLength, negative.numberLength);
                ++i;
                while (i < limit && (digit = ~(negative.digits[i] | positive.digits[i])) == 0) {
                    ++i;
                }
                if (digit == 0) {
                    while (i < positive.numberLength && (digit = ~positive.digits[i]) == 0) {
                        ++i;
                    }
                    while (i < negative.numberLength && (digit = ~negative.digits[i]) == 0) {
                        ++i;
                    }
                    if (digit == 0) {
                        int[] resDigits2 = new int[++resLength];
                        resDigits2[resLength - 1] = 1;
                        BigInteger result = new BigInteger(-1, resLength, resDigits2);
                        return result;
                    }
                }
            }
            resDigits = new int[resLength];
            resDigits[i] = -digit;
            ++i;
        }
        limit = Math.min(positive.numberLength, negative.numberLength);
        while (i < limit) {
            resDigits[i] = negative.digits[i] | positive.digits[i];
            ++i;
        }
        while (i < negative.numberLength) {
            resDigits[i] = negative.digits[i];
            ++i;
        }
        while (i < positive.numberLength) {
            resDigits[i] = positive.digits[i];
            ++i;
        }
        BigInteger result = new BigInteger(-1, resLength, resDigits);
        return result;
    }

    static BigInteger andNotPositive(BigInteger val, BigInteger that) {
        int i;
        int[] resDigits = new int[val.numberLength];
        int limit = Math.min(val.numberLength, that.numberLength);
        for (i = val.getFirstNonzeroDigit(); i < limit; ++i) {
            resDigits[i] = val.digits[i] & ~that.digits[i];
        }
        while (i < val.numberLength) {
            resDigits[i] = val.digits[i];
            ++i;
        }
        BigInteger result = new BigInteger(1, val.numberLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static BigInteger andNotPositiveNegative(BigInteger positive, BigInteger negative) {
        int i;
        int iNeg = negative.getFirstNonzeroDigit();
        int iPos = positive.getFirstNonzeroDigit();
        if (iNeg >= positive.numberLength) {
            return positive;
        }
        int resLength = Math.min(positive.numberLength, negative.numberLength);
        int[] resDigits = new int[resLength];
        for (i = iPos; i < iNeg; ++i) {
            resDigits[i] = positive.digits[i];
        }
        if (i == iNeg) {
            resDigits[i] = positive.digits[i] & negative.digits[i] - 1;
            ++i;
        }
        while (i < resLength) {
            resDigits[i] = positive.digits[i] & negative.digits[i];
            ++i;
        }
        BigInteger result = new BigInteger(1, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static BigInteger andPositive(BigInteger val, BigInteger that) {
        int resLength = Math.min(val.numberLength, that.numberLength);
        int i = Math.max(val.getFirstNonzeroDigit(), that.getFirstNonzeroDigit());
        if (i >= resLength) {
            return BigInteger.ZERO;
        }
        int[] resDigits = new int[resLength];
        while (i < resLength) {
            resDigits[i] = val.digits[i] & that.digits[i];
            ++i;
        }
        BigInteger result = new BigInteger(1, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static BigInteger not(BigInteger val) {
        int i;
        if (val.sign == 0) {
            return BigInteger.MINUS_ONE;
        }
        if (val.equals(BigInteger.MINUS_ONE)) {
            return BigInteger.ZERO;
        }
        int[] resDigits = new int[val.numberLength + 1];
        if (val.sign > 0) {
            if (val.digits[val.numberLength - 1] != -1) {
                i = 0;
                while (val.digits[i] == -1) {
                    ++i;
                }
            } else {
                for (i = 0; i < val.numberLength && val.digits[i] == -1; ++i) {
                }
                if (i == val.numberLength) {
                    resDigits[i] = 1;
                    return new BigInteger(-val.sign, i + 1, resDigits);
                }
            }
        } else {
            i = 0;
            while (val.digits[i] == 0) {
                resDigits[i] = -1;
                ++i;
            }
        }
        resDigits[i] = val.digits[i] + val.sign;
        ++i;
        while (i < val.numberLength) {
            resDigits[i] = val.digits[i];
            ++i;
        }
        return new BigInteger(-val.sign, i, resDigits);
    }

    static BigInteger or(BigInteger val, BigInteger that) {
        if (that.equals(BigInteger.MINUS_ONE) || val.equals(BigInteger.MINUS_ONE)) {
            return BigInteger.MINUS_ONE;
        }
        if (that.sign == 0) {
            return val;
        }
        if (val.sign == 0) {
            return that;
        }
        if (val.sign > 0) {
            if (that.sign > 0) {
                if (val.numberLength > that.numberLength) {
                    return Logical.orPositive(val, that);
                }
                return Logical.orPositive(that, val);
            }
            return Logical.orDiffSigns(val, that);
        }
        if (that.sign > 0) {
            return Logical.orDiffSigns(that, val);
        }
        if (that.getFirstNonzeroDigit() > val.getFirstNonzeroDigit()) {
            return Logical.orNegative(that, val);
        }
        return Logical.orNegative(val, that);
    }

    static BigInteger orDiffSigns(BigInteger positive, BigInteger negative) {
        int limit;
        int i;
        int iNeg = negative.getFirstNonzeroDigit();
        int iPos = positive.getFirstNonzeroDigit();
        if (iPos >= negative.numberLength) {
            return negative;
        }
        int resLength = negative.numberLength;
        int[] resDigits = new int[resLength];
        if (iNeg < iPos) {
            for (i = iNeg; i < iPos; ++i) {
                resDigits[i] = negative.digits[i];
            }
        } else if (iPos < iNeg) {
            i = iPos;
            resDigits[i] = -positive.digits[i];
            limit = Math.min(positive.numberLength, iNeg);
            ++i;
            while (i < limit) {
                resDigits[i] = ~positive.digits[i];
                ++i;
            }
            if (i != positive.numberLength) {
                resDigits[i] = ~(-negative.digits[i] | positive.digits[i]);
            } else {
                while (i < iNeg) {
                    resDigits[i] = -1;
                    ++i;
                }
                resDigits[i] = negative.digits[i] - 1;
            }
            ++i;
        } else {
            i = iPos;
            resDigits[i] = -(-negative.digits[i] | positive.digits[i]);
            ++i;
        }
        limit = Math.min(negative.numberLength, positive.numberLength);
        while (i < limit) {
            resDigits[i] = negative.digits[i] & ~positive.digits[i];
            ++i;
        }
        while (i < negative.numberLength) {
            resDigits[i] = negative.digits[i];
            ++i;
        }
        BigInteger result = new BigInteger(-1, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static BigInteger orNegative(BigInteger val, BigInteger that) {
        int i;
        int iThat = that.getFirstNonzeroDigit();
        int iVal = val.getFirstNonzeroDigit();
        if (iVal >= that.numberLength) {
            return that;
        }
        if (iThat >= val.numberLength) {
            return val;
        }
        int resLength = Math.min(val.numberLength, that.numberLength);
        int[] resDigits = new int[resLength];
        if (iThat == iVal) {
            resDigits[iVal] = -(-val.digits[iVal] | -that.digits[iVal]);
            i = iVal;
        } else {
            for (i = iThat; i < iVal; ++i) {
                resDigits[i] = that.digits[i];
            }
            resDigits[i] = that.digits[i] & val.digits[i] - 1;
        }
        ++i;
        while (i < resLength) {
            resDigits[i] = val.digits[i] & that.digits[i];
            ++i;
        }
        BigInteger result = new BigInteger(-1, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static BigInteger orPositive(BigInteger longer, BigInteger shorter) {
        int resLength = longer.numberLength;
        int[] resDigits = new int[resLength];
        int i = Math.min(longer.getFirstNonzeroDigit(), shorter.getFirstNonzeroDigit());
        for (i = 0; i < shorter.numberLength; ++i) {
            resDigits[i] = longer.digits[i] | shorter.digits[i];
        }
        while (i < resLength) {
            resDigits[i] = longer.digits[i];
            ++i;
        }
        BigInteger result = new BigInteger(1, resLength, resDigits);
        return result;
    }

    static BigInteger xor(BigInteger val, BigInteger that) {
        if (that.sign == 0) {
            return val;
        }
        if (val.sign == 0) {
            return that;
        }
        if (that.equals(BigInteger.MINUS_ONE)) {
            return val.not();
        }
        if (val.equals(BigInteger.MINUS_ONE)) {
            return that.not();
        }
        if (val.sign > 0) {
            if (that.sign > 0) {
                if (val.numberLength > that.numberLength) {
                    return Logical.xorPositive(val, that);
                }
                return Logical.xorPositive(that, val);
            }
            return Logical.xorDiffSigns(val, that);
        }
        if (that.sign > 0) {
            return Logical.xorDiffSigns(that, val);
        }
        if (that.getFirstNonzeroDigit() > val.getFirstNonzeroDigit()) {
            return Logical.xorNegative(that, val);
        }
        return Logical.xorNegative(val, that);
    }

    static BigInteger xorDiffSigns(BigInteger positive, BigInteger negative) {
        int limit;
        int i;
        int[] resDigits;
        int iPos;
        int resLength = Math.max(negative.numberLength, positive.numberLength);
        int iNeg = negative.getFirstNonzeroDigit();
        if (iNeg < (iPos = positive.getFirstNonzeroDigit())) {
            resDigits = new int[resLength];
            i = iNeg;
            resDigits[i] = negative.digits[i];
            limit = Math.min(negative.numberLength, iPos);
            ++i;
            while (i < limit) {
                resDigits[i] = negative.digits[i];
                ++i;
            }
            if (i == negative.numberLength) {
                while (i < positive.numberLength) {
                    resDigits[i] = positive.digits[i];
                    ++i;
                }
            }
        } else if (iPos < iNeg) {
            resDigits = new int[resLength];
            i = iPos;
            resDigits[i] = -positive.digits[i];
            limit = Math.min(positive.numberLength, iNeg);
            ++i;
            while (i < limit) {
                resDigits[i] = ~positive.digits[i];
                ++i;
            }
            if (i == iNeg) {
                resDigits[i] = ~(positive.digits[i] ^ -negative.digits[i]);
                ++i;
            } else {
                while (i < iNeg) {
                    resDigits[i] = -1;
                    ++i;
                }
                while (i < negative.numberLength) {
                    resDigits[i] = negative.digits[i];
                    ++i;
                }
            }
        } else {
            i = iNeg;
            int digit = positive.digits[i] ^ -negative.digits[i];
            if (digit == 0) {
                limit = Math.min(positive.numberLength, negative.numberLength);
                ++i;
                while (i < limit && (digit = positive.digits[i] ^ ~negative.digits[i]) == 0) {
                    ++i;
                }
                if (digit == 0) {
                    while (i < positive.numberLength && (digit = ~positive.digits[i]) == 0) {
                        ++i;
                    }
                    while (i < negative.numberLength && (digit = ~negative.digits[i]) == 0) {
                        ++i;
                    }
                    if (digit == 0) {
                        int[] resDigits2 = new int[++resLength];
                        resDigits2[resLength - 1] = 1;
                        BigInteger result = new BigInteger(-1, resLength, resDigits2);
                        return result;
                    }
                }
            }
            resDigits = new int[resLength];
            resDigits[i] = -digit;
            ++i;
        }
        limit = Math.min(negative.numberLength, positive.numberLength);
        while (i < limit) {
            resDigits[i] = ~(~negative.digits[i] ^ positive.digits[i]);
            ++i;
        }
        while (i < positive.numberLength) {
            resDigits[i] = positive.digits[i];
            ++i;
        }
        while (i < negative.numberLength) {
            resDigits[i] = negative.digits[i];
            ++i;
        }
        BigInteger result = new BigInteger(-1, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static BigInteger xorNegative(BigInteger val, BigInteger that) {
        int limit;
        int iThat;
        int resLength = Math.max(val.numberLength, that.numberLength);
        int[] resDigits = new int[resLength];
        int iVal = val.getFirstNonzeroDigit();
        int i = iThat = that.getFirstNonzeroDigit();
        if (iVal == iThat) {
            resDigits[i] = -val.digits[i] ^ -that.digits[i];
        } else {
            resDigits[i] = -that.digits[i];
            limit = Math.min(that.numberLength, iVal);
            ++i;
            while (i < limit) {
                resDigits[i] = ~that.digits[i];
                ++i;
            }
            if (i == that.numberLength) {
                while (i < iVal) {
                    resDigits[i] = -1;
                    ++i;
                }
                resDigits[i] = val.digits[i] - 1;
            } else {
                resDigits[i] = -val.digits[i] ^ ~that.digits[i];
            }
        }
        limit = Math.min(val.numberLength, that.numberLength);
        ++i;
        while (i < limit) {
            resDigits[i] = val.digits[i] ^ that.digits[i];
            ++i;
        }
        while (i < val.numberLength) {
            resDigits[i] = val.digits[i];
            ++i;
        }
        while (i < that.numberLength) {
            resDigits[i] = that.digits[i];
            ++i;
        }
        BigInteger result = new BigInteger(1, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static BigInteger xorPositive(BigInteger longer, BigInteger shorter) {
        int i;
        int resLength = longer.numberLength;
        int[] resDigits = new int[resLength];
        for (i = Math.min(longer.getFirstNonzeroDigit(), shorter.getFirstNonzeroDigit()); i < shorter.numberLength; ++i) {
            resDigits[i] = longer.digits[i] ^ shorter.digits[i];
        }
        while (i < longer.numberLength) {
            resDigits[i] = longer.digits[i];
            ++i;
        }
        BigInteger result = new BigInteger(1, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    private Logical() {
    }
}

