/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ArrayListBase;
import java.util.Collection;
import javaemul.internal.ArrayHelper;
import javaemul.internal.InternalPreconditions;

public class ArrayList<E>
extends ArrayListBase<E> {
    public ArrayList() {
        this.array = new Object[0];
    }

    public ArrayList(Collection<? extends E> c) {
        this();
        this.addAllImpl(0, c);
    }

    public ArrayList(int initialCapacity) {
        this();
        InternalPreconditions.checkArgument(initialCapacity >= 0, "Initial capacity must not be negative");
    }

    @Override
    public boolean add(E o) {
        ArrayHelper.push(this.array, o);
        return true;
    }

    @Override
    public void add(int index, E o) {
        InternalPreconditions.checkPositionIndex(index, this.array.length);
        ArrayHelper.insertTo(this.array, index, o);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        InternalPreconditions.checkPositionIndex(index, this.array.length);
        return this.addAllImpl(index, c);
    }

    private boolean addAllImpl(int insertIndex, Collection<? extends E> c) {
        Object[] values = c.toArray();
        int len = values.length;
        if (len == 0) {
            return false;
        }
        int newLength = this.array.length + len;
        ArrayHelper.setLength(this.array, newLength);
        int insertEndIndex = insertIndex + len;
        ArrayHelper.copy((Object)this.array, insertIndex, (Object)this.array, insertEndIndex, newLength - insertEndIndex);
        ArrayHelper.copy((Object)values, 0, (Object)this.array, insertIndex, len);
        return true;
    }

    public Object clone() {
        return new ArrayList<E>(this);
    }

    public void ensureCapacity(int ignored) {
    }

    @Override
    void removeImpl(int index) {
        ArrayHelper.removeFrom(this.array, index, 1);
    }

    @Override
    int sizeImpl() {
        return this.array.length;
    }

    @Override
    public Object[] toArray() {
        return ArrayHelper.clone(this.array);
    }

    public void trimToSize() {
    }

    @Override
    protected void removeRange(int fromIndex, int endIndex) {
        InternalPreconditions.checkPositionIndexes(fromIndex, endIndex, this.array.length);
        int count = endIndex - fromIndex;
        ArrayHelper.removeFrom(this.array, fromIndex, count);
    }

    @Override
    void setSize(int newSize) {
        ArrayHelper.setLength(this.array, newSize);
    }
}

