/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;

public interface Spliterator<T> {
    public static final int DISTINCT = 1;
    public static final int ORDERED = 16;
    public static final int NONNULL = 256;
    public static final int CONCURRENT = 4096;
    public static final int SORTED = 4;
    public static final int SIZED = 64;
    public static final int IMMUTABLE = 1024;
    public static final int SUBSIZED = 16384;

    public int characteristics();

    public long estimateSize();

    default public void forEachRemaining(Consumer<? super T> consumer) {
        while (this.tryAdvance(consumer)) {
        }
    }

    default public Comparator<? super T> getComparator() {
        throw new IllegalStateException();
    }

    default public long getExactSizeIfKnown() {
        return this.hasCharacteristics(64) ? this.estimateSize() : -1L;
    }

    default public boolean hasCharacteristics(int characteristics) {
        return (this.characteristics() & characteristics) != 0;
    }

    public boolean tryAdvance(Consumer<? super T> var1);

    public Spliterator<T> trySplit();

    public static interface OfLong
    extends OfPrimitive<Long, LongConsumer, OfLong> {
        @Override
        default public boolean tryAdvance(Consumer<? super Long> consumer) {
            if (consumer instanceof LongConsumer) {
                return this.tryAdvance((LongConsumer)((Object)consumer));
            }
            return this.tryAdvance(consumer::accept);
        }

        @Override
        default public void forEachRemaining(Consumer<? super Long> consumer) {
            if (consumer instanceof LongConsumer) {
                this.forEachRemaining((LongConsumer)((Object)consumer));
            } else {
                this.forEachRemaining(consumer::accept);
            }
        }
    }

    public static interface OfInt
    extends OfPrimitive<Integer, IntConsumer, OfInt> {
        @Override
        default public boolean tryAdvance(Consumer<? super Integer> consumer) {
            if (consumer instanceof IntConsumer) {
                return this.tryAdvance((IntConsumer)((Object)consumer));
            }
            return this.tryAdvance(consumer::accept);
        }

        @Override
        default public void forEachRemaining(Consumer<? super Integer> consumer) {
            if (consumer instanceof IntConsumer) {
                this.forEachRemaining((IntConsumer)((Object)consumer));
            } else {
                this.forEachRemaining(consumer::accept);
            }
        }
    }

    public static interface OfDouble
    extends OfPrimitive<Double, DoubleConsumer, OfDouble> {
        @Override
        default public boolean tryAdvance(Consumer<? super Double> consumer) {
            if (consumer instanceof DoubleConsumer) {
                return this.tryAdvance((DoubleConsumer)((Object)consumer));
            }
            return this.tryAdvance(consumer::accept);
        }

        @Override
        default public void forEachRemaining(Consumer<? super Double> consumer) {
            if (consumer instanceof DoubleConsumer) {
                this.forEachRemaining((DoubleConsumer)((Object)consumer));
            } else {
                this.forEachRemaining(consumer::accept);
            }
        }
    }

    public static interface OfPrimitive<T, C, S extends OfPrimitive<T, C, S>>
    extends Spliterator<T> {
        public boolean tryAdvance(C var1);

        public S trySplit();

        default public void forEachRemaining(C consumer) {
            while (this.tryAdvance(consumer)) {
            }
        }
    }
}

