/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.CollectorImpl;
import javaemul.internal.InternalPreconditions;

public interface Collector<T, A, R> {
    public static <T, A, R> Collector<T, A, R> of(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Characteristics ... characteristics) {
        InternalPreconditions.checkNotNull(supplier);
        InternalPreconditions.checkNotNull(accumulator);
        InternalPreconditions.checkNotNull(combiner);
        InternalPreconditions.checkNotNull(finisher);
        InternalPreconditions.checkNotNull(characteristics);
        return new CollectorImpl<T, A, R>(supplier, accumulator, combiner, finisher, characteristics);
    }

    public static <T, R> Collector<T, R, R> of(Supplier<R> supplier, BiConsumer<R, T> accumulator, BinaryOperator<R> combiner, Characteristics ... characteristics) {
        InternalPreconditions.checkNotNull(supplier);
        InternalPreconditions.checkNotNull(accumulator);
        InternalPreconditions.checkNotNull(combiner);
        InternalPreconditions.checkNotNull(characteristics);
        return new CollectorImpl(supplier, accumulator, combiner, Function.identity(), characteristics);
    }

    public Supplier<A> supplier();

    public BiConsumer<A, T> accumulator();

    public Set<Characteristics> characteristics();

    public BinaryOperator<A> combiner();

    public Function<A, R> finisher();

    public static enum Characteristics {
        CONCURRENT,
        IDENTITY_FINISH,
        UNORDERED;

    }
}

