/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IntSummaryStatistics;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.CollectorImpl;
import java.util.stream.Stream;

public final class Collectors {
    public static <T> Collector<T, ?, Double> averagingDouble(ToDoubleFunction<? super T> mapper) {
        return Collectors.collectingAndThen(Collectors.summarizingDouble(mapper), DoubleSummaryStatistics::getAverage);
    }

    public static <T> Collector<T, ?, Double> averagingInt(ToIntFunction<? super T> mapper) {
        return Collectors.collectingAndThen(Collectors.summarizingInt(mapper), IntSummaryStatistics::getAverage);
    }

    public static <T> Collector<T, ?, Double> averagingLong(ToLongFunction<? super T> mapper) {
        return Collectors.collectingAndThen(Collectors.summarizingLong(mapper), LongSummaryStatistics::getAverage);
    }

    public static <T, A, R, RR> Collector<T, A, RR> collectingAndThen(Collector<T, A, R> downstream, Function<R, RR> finisher) {
        return new CollectorImpl<T, A, RR>(downstream.supplier(), downstream.accumulator(), downstream.combiner(), downstream.finisher().andThen(finisher), new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, Long> counting() {
        return Collectors.reducing(0L, item -> 1L, (a, b) -> Long.valueOf(a) + b);
    }

    public static <T, K> Collector<T, ?, Map<K, List<T>>> groupingBy(Function<? super T, ? extends K> classifier) {
        return Collectors.groupingBy(classifier, Collectors.toList());
    }

    public static <T, K, A, D> Collector<T, ?, Map<K, D>> groupingBy(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return Collectors.groupingBy(classifier, HashMap::new, downstream);
    }

    public static <T, K, D, A, M extends Map<K, D>> Collector<T, ?, M> groupingBy(Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Collector<? super T, A, D> downstream) {
        return Collectors.groupingBy0(() -> new LinkedHashMap(), classifier, mapFactory, downstream);
    }

    private static <T, K, D, A, M extends Map<K, D>> Collector<T, ?, M> groupingBy0(Supplier<Map<K, List<T>>> supplier, Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Collector<? super T, A, D> downstream) {
        return Collector.of(supplier, (m, o) -> {
            Object k = classifier.apply(o);
            ArrayList<Object> l = (ArrayList<Object>)m.get(k);
            if (l == null) {
                l = new ArrayList<Object>();
                m.put(k, l);
            }
            l.add(o);
        }, (m1, m2) -> Collectors.mergeAll(m1, m2, Collectors::addAll), m -> {
            Map result = (Map)mapFactory.get();
            for (Map.Entry entry : m.entrySet()) {
                result.put(entry.getKey(), Collectors.streamAndCollect(downstream, (List)entry.getValue()));
            }
            return result;
        }, new Collector.Characteristics[0]);
    }

    public static Collector<CharSequence, ?, String> joining() {
        return Collector.of(StringBuilder::new, StringBuilder::append, StringBuilder::append, rec$ -> ((StringBuilder)rec$).toString(), new Collector.Characteristics[0]);
    }

    public static Collector<CharSequence, ?, String> joining(CharSequence delimiter) {
        return Collectors.joining(delimiter, "", "");
    }

    public static Collector<CharSequence, ?, String> joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return Collector.of(() -> new StringJoiner(delimiter, prefix, suffix), StringJoiner::add, StringJoiner::merge, StringJoiner::toString, new Collector.Characteristics[0]);
    }

    public static <T, U, A, R> Collector<T, ?, R> mapping(Function<? super T, ? extends U> mapper, Collector<? super U, A, R> downstream) {
        return new CollectorImpl<Object, Object, R>(downstream.supplier(), (a, t) -> downstream.accumulator().accept(a, mapper.apply(t)), downstream.combiner(), downstream.finisher(), new Collector.Characteristics[0]);
    }

    public static <T, U, A, R> Collector<T, ?, R> flatMapping(Function<? super T, ? extends Stream<? extends U>> mapper, Collector<? super U, A, R> downstream) {
        return new CollectorImpl<Object, Object, R>(downstream.supplier(), (a, t) -> {
            try (Stream stream = (Stream)mapper.apply(t);){
                if (stream == null) {
                    return;
                }
                stream.forEach(u -> downstream.accumulator().accept(a, u));
            }
        }, downstream.combiner(), downstream.finisher(), new Collector.Characteristics[0]);
    }

    public static <T, A, R> Collector<T, ?, R> filtering(Predicate<? super T> predicate, Collector<? super T, A, R> downstream) {
        return new CollectorImpl<Object, Object, R>(downstream.supplier(), (a, t) -> {
            if (predicate.test(t)) {
                downstream.accumulator().accept(a, t);
            }
        }, downstream.combiner(), downstream.finisher(), new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, Optional<T>> maxBy(Comparator<? super T> comparator) {
        return Collectors.reducing(BinaryOperator.maxBy(comparator));
    }

    public static <T> Collector<T, ?, Optional<T>> minBy(Comparator<? super T> comparator) {
        return Collectors.reducing(BinaryOperator.minBy(comparator));
    }

    public static <T> Collector<T, ?, Map<Boolean, List<T>>> partitioningBy(Predicate<? super T> predicate) {
        return Collectors.partitioningBy(predicate, Collectors.toList());
    }

    public static <T, D, A> Collector<T, ?, Map<Boolean, D>> partitioningBy(Predicate<? super T> predicate, Collector<? super T, A, D> downstream) {
        return Collectors.groupingBy0(Collectors.partitionSupplier(), predicate::test, HashMap::new, downstream);
    }

    private static <T> Supplier<Map<Boolean, List<T>>> partitionSupplier() {
        return () -> {
            LinkedHashMap partition = new LinkedHashMap();
            partition.put(false, new ArrayList());
            partition.put(true, new ArrayList());
            return partition;
        };
    }

    public static <T> Collector<T, ?, Optional<T>> reducing(BinaryOperator<T> op) {
        return Collectors.reducing(Optional.empty(), Optional::of, (a, b) -> {
            if (!a.isPresent()) {
                return b;
            }
            if (!b.isPresent()) {
                return a;
            }
            return Optional.of(op.apply(a.get(), b.get()));
        });
    }

    public static <T> Collector<T, ?, T> reducing(T identity, BinaryOperator<T> op) {
        return Collectors.reducing(identity, Function.identity(), op);
    }

    public static <T, U> Collector<T, ?, U> reducing(U identity, Function<? super T, ? extends U> mapper, BinaryOperator<U> op) {
        return Collector.of(() -> new Object[]{identity}, (u, t) -> {
            u[0] = op.apply(u[0], mapper.apply(t));
        }, (u1, u2) -> {
            u1[0] = op.apply(u1[0], u2[0]);
            return u1;
        }, a -> a[0], new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, DoubleSummaryStatistics> summarizingDouble(ToDoubleFunction<? super T> mapper) {
        return Collector.of(DoubleSummaryStatistics::new, (stats, item) -> stats.accept(mapper.applyAsDouble(item)), (t, u) -> {
            t.combine((DoubleSummaryStatistics)u);
            return t;
        }, Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <T> Collector<T, ?, IntSummaryStatistics> summarizingInt(ToIntFunction<? super T> mapper) {
        return Collector.of(IntSummaryStatistics::new, (stats, item) -> stats.accept(mapper.applyAsInt(item)), (t, u) -> {
            t.combine((IntSummaryStatistics)u);
            return t;
        }, Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <T> Collector<T, ?, LongSummaryStatistics> summarizingLong(ToLongFunction<? super T> mapper) {
        return Collector.of(LongSummaryStatistics::new, (stats, item) -> stats.accept(mapper.applyAsLong(item)), (t, u) -> {
            t.combine((LongSummaryStatistics)u);
            return t;
        }, Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <T> Collector<T, ?, Double> summingDouble(ToDoubleFunction<? super T> mapper) {
        return Collectors.collectingAndThen(Collectors.summarizingDouble(mapper), DoubleSummaryStatistics::getSum);
    }

    public static <T> Collector<T, ?, Integer> summingInt(ToIntFunction<? super T> mapper) {
        return Collectors.collectingAndThen(Collectors.summarizingInt(mapper), intSummaryStatistics -> (int)intSummaryStatistics.getSum());
    }

    public static <T> Collector<T, ?, Long> summingLong(ToLongFunction<? super T> mapper) {
        return Collectors.collectingAndThen(Collectors.summarizingLong(mapper), LongSummaryStatistics::getSum);
    }

    public static <T, C extends Collection<T>> Collector<T, ?, C> toCollection(Supplier<C> collectionFactory) {
        return Collector.of(collectionFactory, Collection::add, (c1, c2) -> Collectors.addAll(c1, c2), Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <T> Collector<T, ?, List<T>> toList() {
        return Collectors.toCollection(ArrayList::new);
    }

    public static <T> Collector<T, ?, List<T>> toUnmodifiableList() {
        Collector<Object, ?, List<T>> mapping = Collectors.mapping(Objects::requireNonNull, Collectors.toList());
        return Collectors.collectingAndThen(mapping, Collections::unmodifiableList);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, (m1, m2) -> {
            throw new IllegalStateException("Can't assign multiple values to the same key");
        });
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return Collectors.toMap(keyMapper, valueMapper, mergeFunction, HashMap::new);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toUnmodifiableMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.collectingAndThen(Collectors.toMap(Collectors.disallowNulls(keyMapper), Collectors.disallowNulls(valueMapper)), Collections::unmodifiableMap);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toUnmodifiableMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return Collectors.collectingAndThen(Collectors.toMap(Collectors.disallowNulls(keyMapper), Collectors.disallowNulls(valueMapper), mergeFunction), Collections::unmodifiableMap);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapSupplier) {
        return Collector.of(mapSupplier, (map, item) -> {
            Object key = keyMapper.apply(item);
            Object value = valueMapper.apply(item);
            map.merge(key, value, mergeFunction);
        }, (m1, m2) -> Collectors.mergeAll(m1, m2, mergeFunction), Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <T> Collector<T, ?, Set<T>> toSet() {
        return Collector.of(HashSet::new, HashSet::add, (c1, c2) -> Collectors.addAll(c1, c2), s -> s, Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <T> Collector<T, ?, Set<T>> toUnmodifiableSet() {
        Collector<Object, ?, Set<T>> mapping = Collectors.mapping(Objects::requireNonNull, Collectors.toSet());
        return Collectors.collectingAndThen(mapping, Collections::unmodifiableSet);
    }

    private static <T, D, A> D streamAndCollect(Collector<? super T, A, D> downstream, List<T> list) {
        A a = downstream.supplier().get();
        for (T t : list) {
            downstream.accumulator().accept(a, t);
        }
        return downstream.finisher().apply(a);
    }

    private static <K, V, M extends Map<K, V>> M mergeAll(M m1, M m2, BinaryOperator<V> mergeFunction) {
        for (Map.Entry<K, V> entry : m2.entrySet()) {
            m1.merge(entry.getKey(), entry.getValue(), mergeFunction);
        }
        return m1;
    }

    private static <T, C extends Collection<T>> C addAll(C collection, Collection<T> items) {
        collection.addAll(items);
        return collection;
    }

    private static <T, R> Function<T, R> disallowNulls(Function<T, R> func) {
        return x -> Objects.requireNonNull(func.apply(x));
    }

    private Collectors() {
    }
}

