/*
 * Decompiled with CFR 0.152.
 */
package javaemul.internal;

import java.nio.charset.Charset;
import javaemul.internal.ArrayHelper;
import javaemul.internal.PrimitiveLists;

public abstract class EmulatedCharset
extends Charset {
    public static final EmulatedCharset UTF_8 = new UtfCharset("UTF-8");
    public static final EmulatedCharset ISO_LATIN_1 = new LatinCharset("ISO-LATIN-1");
    public static final EmulatedCharset ISO_8859_1 = new LatinCharset("ISO-8859-1");

    public EmulatedCharset(String name) {
        super(name, null);
    }

    public final byte[] getBytes(String string) {
        return this.getBytes(string, false);
    }

    public abstract byte[] getBytes(String var1, boolean var2);

    public final byte[] getBytes(char[] buffer, int offset, int count) {
        return this.getBytes(buffer, offset, count, false);
    }

    public abstract byte[] getBytes(char[] var1, int var2, int var3, boolean var4);

    public final char[] decodeString(byte[] bytes, int ofs, int len) {
        return this.decodeString(bytes, ofs, len, false);
    }

    public abstract char[] decodeString(byte[] var1, int var2, int var3, boolean var4);

    private static class UtfCharset
    extends EmulatedCharset {
        private static final char REPLACEMENT_CHAR = '\ufffd';

        public UtfCharset(String name) {
            super(name);
        }

        @Override
        public char[] decodeString(byte[] bytes, int ofs, int len, boolean throwOnInvalid) {
            char[] chars = new char[]{};
            chars = ArrayHelper.setLength(chars, len * 2);
            int outIdx = 0;
            int count = 0;
            int i = 0;
            while (i < len) {
                int ch;
                boolean invalid = false;
                int runStartIdx = i;
                if (((ch = bytes[ofs + i++]) & 0x80) == 0) {
                    count = 1;
                    ch &= 0x7F;
                } else if ((ch & 0xE0) == 192) {
                    count = 2;
                    ch &= 0x1F;
                } else if ((ch & 0xF0) == 224) {
                    count = 3;
                    ch &= 0xF;
                } else if ((ch & 0xF8) == 240) {
                    count = 4;
                    ch &= 7;
                } else {
                    invalid = true;
                    count = 1;
                }
                int end = i + count - 1;
                if (end > len) {
                    if (throwOnInvalid) {
                        throw new IndexOutOfBoundsException();
                    }
                    invalid = true;
                }
                while (!invalid && i < end) {
                    byte b;
                    if (((b = bytes[ofs + i++]) & 0xC0) != 128) {
                        invalid = true;
                        --i;
                        continue;
                    }
                    ch = ch << 6 | b & 0x3F;
                }
                if (ch <= 65535 && Character.isSurrogate((char)ch)) {
                    invalid = true;
                }
                if (invalid || UtfCharset.isOverlong(ch, count)) {
                    if (throwOnInvalid) {
                        throw new IllegalArgumentException();
                    }
                    int j = runStartIdx;
                    while (j++ < i) {
                        chars[outIdx++] = 65533;
                    }
                    continue;
                }
                outIdx += Character.toChars(ch, chars, outIdx);
            }
            chars = ArrayHelper.setLength(chars, outIdx);
            return chars;
        }

        private static boolean isOverlong(int codepoint, int count) {
            return codepoint <= 127 && count > 1 || codepoint <= 2047 && count > 2 || codepoint <= 65535 && count > 3;
        }

        @Override
        public byte[] getBytes(char[] buffer, int offset, int count, boolean throwOnInvalid) {
            int ch;
            int n = offset + count;
            PrimitiveLists.Byte bytes = PrimitiveLists.createForByte();
            for (int i = offset; i < n; i += Character.charCount(ch)) {
                ch = UtfCharset.getCodePointAt(buffer, i, throwOnInvalid);
                this.encodeUtf8(bytes, ch, throwOnInvalid);
            }
            return bytes.toArray();
        }

        private static int getCodePointAt(char[] buffer, int pos, boolean throwOnInvalid) {
            char low;
            char ch = buffer[pos];
            if (!Character.isSurrogate(ch)) {
                return ch;
            }
            char high = ch;
            char c = low = pos + 1 < buffer.length ? buffer[pos + 1] : (char)'\u00ff';
            if (!Character.isSurrogatePair(high, low)) {
                if (throwOnInvalid) {
                    throw new IllegalArgumentException("Invalid surrogate pair");
                }
                return 63;
            }
            return Character.toCodePoint(high, low);
        }

        @Override
        public byte[] getBytes(String str, boolean throwOnInvalid) {
            int ch;
            int n = str.length();
            PrimitiveLists.Byte bytes = PrimitiveLists.createForByte();
            for (int i = 0; i < n; i += Character.charCount(ch)) {
                ch = UtfCharset.getCodePointAt(str, i, n, throwOnInvalid);
                this.encodeUtf8(bytes, ch, throwOnInvalid);
            }
            return bytes.toArray();
        }

        private static int getCodePointAt(String str, int pos, int length, boolean throwOnInvalid) {
            char low;
            char ch = str.charAt(pos);
            if (!Character.isSurrogate(ch)) {
                return ch;
            }
            char high = ch;
            char c = low = pos + 1 < length ? (char)str.charAt(pos + 1) : (char)'\u00ff';
            if (!Character.isSurrogatePair(high, low)) {
                if (throwOnInvalid) {
                    throw new IllegalArgumentException("Invalid surrogate pair");
                }
                return 63;
            }
            return Character.toCodePoint(high, low);
        }

        private void encodeUtf8(PrimitiveLists.Byte bytes, int codePoint, boolean throwOnInvalid) {
            if (codePoint >= 0x4000000) {
                if (throwOnInvalid) {
                    throw new IllegalArgumentException("Character out of range: " + codePoint);
                }
                codePoint = 65533;
            }
            if (codePoint < 128) {
                bytes.push((byte)(codePoint & 0x7F));
            } else if (codePoint < 2048) {
                bytes.push((byte)(codePoint >> 6 & 0x1F | 0xC0));
                bytes.push((byte)(codePoint & 0x3F | 0x80));
            } else if (codePoint < 65536) {
                bytes.push((byte)(codePoint >> 12 & 0xF | 0xE0));
                bytes.push((byte)(codePoint >> 6 & 0x3F | 0x80));
                bytes.push((byte)(codePoint & 0x3F | 0x80));
            } else if (codePoint < 0x200000) {
                bytes.push((byte)(codePoint >> 18 & 7 | 0xF0));
                bytes.push((byte)(codePoint >> 12 & 0x3F | 0x80));
                bytes.push((byte)(codePoint >> 6 & 0x3F | 0x80));
                bytes.push((byte)(codePoint & 0x3F | 0x80));
            } else {
                bytes.push((byte)(codePoint >> 24 & 3 | 0xF8));
                bytes.push((byte)(codePoint >> 18 & 0x3F | 0x80));
                bytes.push((byte)(codePoint >> 12 & 0x3F | 0x80));
                bytes.push((byte)(codePoint >> 6 & 0x3F | 0x80));
                bytes.push((byte)(codePoint & 0x3F | 0x80));
            }
        }
    }

    private static class LatinCharset
    extends EmulatedCharset {
        public LatinCharset(String name) {
            super(name);
        }

        @Override
        public byte[] getBytes(char[] buffer, int offset, int count, boolean throwOnInvalid) {
            int n = offset + count;
            byte[] bytes = new byte[]{};
            bytes = ArrayHelper.setLength(bytes, count);
            for (int i = offset; i < n; ++i) {
                bytes[i] = (byte)(buffer[i] & 0xFF);
            }
            return bytes;
        }

        @Override
        public byte[] getBytes(String str, boolean throwOnInvalid) {
            int n = str.length();
            byte[] bytes = new byte[]{};
            bytes = ArrayHelper.setLength(bytes, n);
            for (int i = 0; i < n; ++i) {
                bytes[i] = (byte)(str.charAt(i) & 0xFF);
            }
            return bytes;
        }

        @Override
        public char[] decodeString(byte[] bytes, int ofs, int len, boolean throwOnInvalid) {
            char[] chars = new char[]{};
            chars = ArrayHelper.setLength(chars, len);
            for (int i = 0; i < len; ++i) {
                chars[i] = (char)(bytes[ofs + i] & 0xFF);
            }
            return chars;
        }
    }
}

