/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.IOUtils;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;

    public ByteArrayOutputStream() {
        this.buf = new byte[32];
    }

    public ByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.buf = new byte[size];
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    private void expand(int i) {
        if (this.count + i <= this.buf.length) {
            return;
        }
        byte[] newbuf = new byte[(this.count + i) * 2];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        this.buf = newbuf;
    }

    public void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public byte[] toByteArray() {
        byte[] newArray = new byte[this.count];
        System.arraycopy(this.buf, 0, newArray, 0, this.count);
        return newArray;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Deprecated
    public String toString(int hibyte) {
        char[] newBuf = new char[this.size()];
        for (int i = 0; i < newBuf.length; ++i) {
            newBuf[i] = (char)((hibyte & 0xFF) << 8 | this.buf[i] & 0xFF);
        }
        return new String(newBuf);
    }

    public String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, charsetName);
    }

    @Override
    public void write(byte[] buffer, int offset, int len) {
        IOUtils.checkOffsetAndCount(buffer, offset, len);
        if (len == 0) {
            return;
        }
        this.expand(len);
        System.arraycopy(buffer, offset, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public void write(int oneByte) {
        if (this.count == this.buf.length) {
            this.expand(1);
        }
        this.buf[this.count++] = (byte)oneByte;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }
}

