/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;
import javaemul.internal.InternalPreconditions;

public class StringReader
extends Reader {
    private final String text;
    private int position;
    private int mark;

    public StringReader(String text) {
        this.text = text;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read(char[] buf, int off, int readLength) {
        if (this.position >= this.text.length()) {
            return -1;
        }
        int length = Math.min(this.text.length() - this.position, readLength);
        this.text.getChars(this.position, this.position + length, buf, off);
        this.position += length;
        return length;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        InternalPreconditions.checkArgument(readAheadLimit >= 0);
        this.mark = this.position;
    }

    @Override
    public void reset() throws IOException {
        this.position = this.mark;
    }
}

