/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import javaemul.internal.annotations.HasNoSideEffects;

public final class Integer
extends Number
implements Comparable<Integer> {
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final int MIN_VALUE = -2147483648;
    public static final int SIZE = 32;
    public static final int BYTES = 4;
    public static final Class<Integer> TYPE;
    private final int value;

    public static int bitCount(int x) {
        x -= x >> 1 & 0x55555555;
        x = (x >> 2 & 0x33333333) + (x & 0x33333333);
        x = (x >> 4) + x & 0xF0F0F0F;
        x += x >> 8;
        x += x >> 16;
        return x & 0x3F;
    }

    public static int compare(int x, int y) {
        if (x < y) {
            return -1;
        }
        if (x > y) {
            return 1;
        }
        return 0;
    }

    public static Integer decode(String s) throws NumberFormatException {
        return Integer.__decodeAndValidateInt(s, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static int hashCode(int i) {
        return i;
    }

    public static int highestOneBit(int i) {
        if (i < 0) {
            return Integer.MIN_VALUE;
        }
        if (i == 0) {
            return 0;
        }
        int rtn = 0x40000000;
        while ((rtn & i) == 0) {
            rtn >>= 1;
        }
        return rtn;
    }

    public static int lowestOneBit(int i) {
        return i & -i;
    }

    public static int max(int a, int b) {
        return Math.max(a, b);
    }

    public static int min(int a, int b) {
        return Math.min(a, b);
    }

    public static int numberOfLeadingZeros(int i) {
        if (i < 0) {
            return 0;
        }
        if (i == 0) {
            return 32;
        }
        int y = -(i >> 16);
        int m = y >> 16 & 0x10;
        int n = 16 - m;
        y = (i >>= m) - 256;
        m = y >> 16 & 8;
        n += m;
        y = (i <<= m) - 4096;
        m = y >> 16 & 4;
        n += m;
        y = (i <<= m) - 16384;
        m = y >> 16 & 2;
        n += m;
        y = (i <<= m) >> 14;
        m = y & ~(y >> 1);
        return n + 2 - m;
    }

    public static int numberOfTrailingZeros(int i) {
        if (i == 0) {
            return 32;
        }
        int rtn = 0;
        int r = 1;
        while ((r & i) == 0) {
            ++rtn;
            r <<= 1;
        }
        return rtn;
    }

    public static int parseInt(String s) throws NumberFormatException {
        return Integer.parseInt(s, 10);
    }

    public static int parseInt(String s, int radix) throws NumberFormatException {
        return Integer.__parseAndValidateInt(s, radix, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static int reverse(int i) {
        int[] nibbles = ReverseNibbles.reverseNibbles;
        return nibbles[i >>> 28] | nibbles[i >> 24 & 0xF] << 4 | nibbles[i >> 20 & 0xF] << 8 | nibbles[i >> 16 & 0xF] << 12 | nibbles[i >> 12 & 0xF] << 16 | nibbles[i >> 8 & 0xF] << 20 | nibbles[i >> 4 & 0xF] << 24 | nibbles[i & 0xF] << 28;
    }

    public static int reverseBytes(int i) {
        return (i & 0xFF) << 24 | (i & 0xFF00) << 8 | (i & 0xFF0000) >> 8 | (i & 0xFF000000) >>> 24;
    }

    public static int rotateLeft(int i, int distance) {
        while (distance-- > 0) {
            i = i << 1 | (i < 0 ? 1 : 0);
        }
        return i;
    }

    public static int rotateRight(int i, int distance) {
        int carry;
        int ui = i & Integer.MAX_VALUE;
        int n = carry = i < 0 ? 0x40000000 : 0;
        while (distance-- > 0) {
            int nextcarry = ui & 1;
            ui = carry | ui >> 1;
            carry = nextcarry == 0 ? 0 : 0x40000000;
        }
        if (carry != 0) {
            ui |= Integer.MIN_VALUE;
        }
        return ui;
    }

    public static int signum(int i) {
        if (i == 0) {
            return 0;
        }
        if (i < 0) {
            return -1;
        }
        return 1;
    }

    public static int sum(int a, int b) {
        return a + b;
    }

    public static String toBinaryString(int i) {
        return IntegralToString.intToBinaryString(i);
    }

    public static String toHexString(int i) {
        return IntegralToString.intToHexString(i);
    }

    public static String toOctalString(int i) {
        return IntegralToString.intToOctalString(i);
    }

    public static String toString(int i) {
        return IntegralToString.intToString(i);
    }

    public static String toString(int i, int radix) {
        return IntegralToString.intToString(i, radix);
    }

    public static Integer valueOf(int i) {
        if (i > -129 && i < 128) {
            return BoxedValues.get(i);
        }
        return new Integer(i);
    }

    public static Integer valueOf(String s) throws NumberFormatException {
        return Integer.valueOf(s, 10);
    }

    public static Integer valueOf(String s, int radix) throws NumberFormatException {
        return Integer.parseInt(s, radix);
    }

    public Integer(int value) {
        this.value = value;
    }

    public Integer(String s) {
        this.value = Integer.parseInt(s);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public int compareTo(Integer b) {
        return Integer.compare(this.value, b.value);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        return o instanceof Integer && ((Integer)o).value == this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    private static class ReverseNibbles {
        private static int[] reverseNibbles = new int[]{0, 8, 4, 12, 2, 10, 6, 14, 1, 9, 5, 13, 3, 11, 7, 15};

        private ReverseNibbles() {
        }
    }

    private static class BoxedValues {
        private static final Integer[] boxedValues;

        private BoxedValues() {
        }

        @HasNoSideEffects
        private static Integer get(int i) {
            return boxedValues[i + 128];
        }

        static {
            Integer[] values = new Integer[256];
            for (int i = 0; i < 256; ++i) {
                values[i] = new Integer(i - 128);
            }
            boxedValues = values;
        }
    }
}

