/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import javaemul.internal.InternalPreconditions;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;

public final class Math {
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;
    private static final double PI_OVER_180 = 0.017453292519943295;
    private static final double PI_UNDER_180 = 57.29577951308232;

    @JsMethod(namespace="<global>", name="Math.abs")
    public static native double abs(double var0);

    @JsMethod(namespace="<global>", name="Math.abs")
    public static native float abs(float var0);

    public static int abs(int x) {
        return x < 0 ? -x : x;
    }

    public static long abs(long x) {
        return x < 0L ? -x : x;
    }

    @JsMethod(namespace="<global>", name="Math.acos")
    public static native double acos(double var0);

    @JsMethod(namespace="<global>", name="Math.asin")
    public static native double asin(double var0);

    public static int addExact(int x, int y) {
        double r = (double)x + (double)y;
        InternalPreconditions.checkCriticalArithmetic(Math.isSafeIntegerRange(r));
        return (int)r;
    }

    public static long addExact(long x, long y) {
        long r = x + y;
        InternalPreconditions.checkCriticalArithmetic(((x ^ r) & (y ^ r)) >= 0L);
        return r;
    }

    @JsMethod(namespace="<global>", name="Math.atan")
    public static native double atan(double var0);

    @JsMethod(namespace="<global>", name="Math.atan2")
    public static native double atan2(double var0, double var2);

    @JsMethod(namespace="<global>", name="Math.cbrt")
    public static native double cbrt(double var0);

    @JsMethod(namespace="<global>", name="Math.ceil")
    public static native double ceil(double var0);

    public static double copySign(double magnitude, double sign) {
        return Math.isNegative(sign) ? -Math.abs(magnitude) : Math.abs(magnitude);
    }

    private static boolean isNegative(double d) {
        return d < 0.0 || 1.0 / d < 0.0;
    }

    public static float copySign(float magnitude, float sign) {
        return (float)Math.copySign((double)magnitude, (double)sign);
    }

    @JsMethod(namespace="<global>", name="Math.cos")
    public static native double cos(double var0);

    @JsMethod(namespace="<global>", name="Math.cosh")
    public static native double cosh(double var0);

    public static int decrementExact(int x) {
        InternalPreconditions.checkCriticalArithmetic(x != Integer.MIN_VALUE);
        return x - 1;
    }

    public static long decrementExact(long x) {
        InternalPreconditions.checkCriticalArithmetic(x != Long.MIN_VALUE);
        return x - 1L;
    }

    @JsMethod(namespace="<global>", name="Math.exp")
    public static native double exp(double var0);

    @JsMethod(namespace="<global>", name="Math.expm1")
    public static native double expm1(double var0);

    @JsMethod(namespace="<global>", name="Math.floor")
    public static native double floor(double var0);

    public static int floorDiv(int dividend, int divisor) {
        InternalPreconditions.checkCriticalArithmetic(divisor != 0);
        return (dividend ^ divisor) >= 0 ? dividend / divisor : (dividend + 1) / divisor - 1;
    }

    public static long floorDiv(long dividend, long divisor) {
        InternalPreconditions.checkCriticalArithmetic(divisor != 0L);
        return (dividend ^ divisor) >= 0L ? dividend / divisor : (dividend + 1L) / divisor - 1L;
    }

    public static int floorMod(int dividend, int divisor) {
        InternalPreconditions.checkCriticalArithmetic(divisor != 0);
        return (dividend % divisor + divisor) % divisor;
    }

    public static long floorMod(long dividend, long divisor) {
        InternalPreconditions.checkCriticalArithmetic(divisor != 0L);
        return (dividend % divisor + divisor) % divisor;
    }

    @JsMethod(namespace="<global>", name="Math.hypot")
    public static native double hypot(double var0, double var2);

    public static int incrementExact(int x) {
        InternalPreconditions.checkCriticalArithmetic(x != Integer.MAX_VALUE);
        return x + 1;
    }

    public static long incrementExact(long x) {
        InternalPreconditions.checkCriticalArithmetic(x != Long.MAX_VALUE);
        return x + 1L;
    }

    @JsMethod(namespace="<global>", name="Math.log")
    public static native double log(double var0);

    @JsMethod(namespace="<global>", name="Math.log10")
    public static native double log10(double var0);

    @JsMethod(namespace="<global>", name="Math.log1p")
    public static native double log1p(double var0);

    @JsMethod(namespace="<global>", name="Math.max")
    public static native double max(double var0, double var2);

    @JsMethod(namespace="<global>", name="Math.max")
    public static native float max(float var0, float var1);

    @JsMethod(namespace="<global>", name="Math.max")
    public static native int max(int var0, int var1);

    public static long max(long x, long y) {
        return x > y ? x : y;
    }

    @JsMethod(namespace="<global>", name="Math.min")
    public static native double min(double var0, double var2);

    @JsMethod(namespace="<global>", name="Math.min")
    public static native float min(float var0, float var1);

    @JsMethod(namespace="<global>", name="Math.min")
    public static native int min(int var0, int var1);

    public static long min(long x, long y) {
        return x < y ? x : y;
    }

    public static int multiplyExact(int x, int y) {
        double r = (double)x * (double)y;
        InternalPreconditions.checkCriticalArithmetic(Math.isSafeIntegerRange(r));
        return (int)r;
    }

    public static long multiplyExact(long x, long y) {
        if (y == -1L) {
            return Math.negateExact(x);
        }
        if (y == 0L) {
            return 0L;
        }
        long r = x * y;
        InternalPreconditions.checkCriticalArithmetic(r / y == x);
        return r;
    }

    public static int negateExact(int x) {
        InternalPreconditions.checkCriticalArithmetic(x != Integer.MIN_VALUE);
        return -x;
    }

    public static long negateExact(long x) {
        InternalPreconditions.checkCriticalArithmetic(x != Long.MIN_VALUE);
        return -x;
    }

    @JsMethod(namespace="<global>", name="Math.pow")
    public static native double pow(double var0, double var2);

    @JsMethod(namespace="<global>", name="Math.random")
    public static native double random();

    public static double rint(double x) {
        if (Math.abs(x) < 4.503599627370496E15) {
            double mod2 = x % 2.0;
            x = mod2 == -1.5 || mod2 == 0.5 ? Math.floor(x) : (double)Math.round(x);
        }
        return x;
    }

    public static long round(double x) {
        return (long)NativeMath.round(x);
    }

    public static int round(float x) {
        return (int)NativeMath.round(x);
    }

    public static int subtractExact(int x, int y) {
        double r = (double)x - (double)y;
        InternalPreconditions.checkCriticalArithmetic(Math.isSafeIntegerRange(r));
        return (int)r;
    }

    public static long subtractExact(long x, long y) {
        long r = x - y;
        InternalPreconditions.checkCriticalArithmetic(((x ^ y) & (x ^ r)) >= 0L);
        return r;
    }

    public static double scalb(double d, int scaleFactor) {
        if (scaleFactor >= 31 || scaleFactor <= -31) {
            return d * Math.pow(2.0, scaleFactor);
        }
        if (scaleFactor > 0) {
            return d * (double)(1 << scaleFactor);
        }
        if (scaleFactor == 0) {
            return d;
        }
        return d / (double)(1 << -scaleFactor);
    }

    public static float scalb(float f, int scaleFactor) {
        return (float)Math.scalb((double)f, scaleFactor);
    }

    @JsMethod(namespace="<global>", name="Math.sign")
    public static native double signum(double var0);

    @JsMethod(namespace="<global>", name="Math.sign")
    public static native float signum(float var0);

    @JsMethod(namespace="<global>", name="Math.sin")
    public static native double sin(double var0);

    @JsMethod(namespace="<global>", name="Math.sinh")
    public static native double sinh(double var0);

    @JsMethod(namespace="<global>", name="Math.sqrt")
    public static native double sqrt(double var0);

    @JsMethod(namespace="<global>", name="Math.tan")
    public static native double tan(double var0);

    @JsMethod(namespace="<global>", name="Math.tanh")
    public static native double tanh(double var0);

    public static double toDegrees(double x) {
        return x * 57.29577951308232;
    }

    public static int toIntExact(long x) {
        int ix = (int)x;
        InternalPreconditions.checkCriticalArithmetic((long)ix == x);
        return ix;
    }

    public static double toRadians(double x) {
        return x * (Math.PI / 180);
    }

    private static boolean isSafeIntegerRange(double value) {
        return -2.147483648E9 <= value && value <= 2.147483647E9;
    }

    @JsType(isNative=true, name="Math", namespace="<global>")
    private static class NativeMath {
        private NativeMath() {
        }

        public static native double round(double var0);
    }
}

