/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import java.util.Objects;

public final class StackTraceElement
implements Serializable {
    private String className;
    private String fileName;
    private int lineNumber;
    private String methodName;

    public StackTraceElement() {
    }

    public StackTraceElement(String className, String methodName, String fileName, int lineNumber) {
        assert (className != null);
        assert (methodName != null);
        this.className = className;
        this.methodName = methodName;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean equals(Object other) {
        if (other instanceof StackTraceElement) {
            StackTraceElement st = (StackTraceElement)other;
            return this.lineNumber == st.lineNumber && Objects.equals(this.methodName, st.methodName) && Objects.equals(this.className, st.className) && Objects.equals(this.fileName, st.fileName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.lineNumber, this.className, this.methodName, this.fileName);
    }

    public String toString() {
        return this.className + "." + this.methodName + "(" + (this.fileName != null ? this.fileName : "Unknown Source") + (this.lineNumber >= 0 ? ":" + this.lineNumber : "") + ")";
    }
}

