/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import javaemul.internal.InternalPreconditions;
import javaemul.internal.ThrowableUtils;
import javaemul.internal.annotations.Wasm;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsNonNull;
import jsinterop.annotations.JsProperty;

public class Throwable
implements Serializable {
    private String detailMessage;
    private Throwable cause;
    private ArrayList<Throwable> suppressedExceptions;
    private StackTraceElement[] stackTrace = new StackTraceElement[0];
    private boolean disableSuppression;
    private boolean disableStackTrace;
    @JsProperty
    private ThrowableUtils.JsObject backingJsObject;

    public Throwable() {
        this.fillInStackTrace();
    }

    public Throwable(String message) {
        this.detailMessage = message;
        this.fillInStackTrace();
    }

    public Throwable(String message, Throwable cause) {
        this.cause = cause;
        this.detailMessage = message;
        this.fillInStackTrace();
    }

    public Throwable(Throwable cause) {
        this.cause = cause;
        if (cause != null) {
            this.detailMessage = cause.toString();
        }
        this.fillInStackTrace();
    }

    protected Throwable(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        this.cause = cause;
        this.detailMessage = message;
        this.disableStackTrace = !writableStackTrace;
        boolean bl = this.disableSuppression = !enableSuppression;
        if (writableStackTrace) {
            this.fillInStackTrace();
        }
    }

    void privateInitError(ThrowableUtils.JsObject error) {
        this.backingJsObject = error;
        ThrowableUtils.setJavaThrowable(error, this);
    }

    public ThrowableUtils.JsObject getBackingJsObject() {
        return this.backingJsObject;
    }

    public final void addSuppressed(Throwable exception) {
        InternalPreconditions.checkNotNull(exception, "Cannot suppress a null exception.");
        InternalPreconditions.checkCriticalArgument(exception != this, "Exception can not suppress itself.");
        if (this.disableSuppression) {
            return;
        }
        if (this.suppressedExceptions == null) {
            this.suppressedExceptions = new ArrayList();
        }
        this.suppressedExceptions.add(exception);
    }

    public Throwable fillInStackTrace() {
        if (!this.disableStackTrace) {
            if (ThrowableUtils.isError(this.backingJsObject)) {
                if (ThrowableUtils.NativeError.hasCaptureStackTraceProperty) {
                    ThrowableUtils.NativeError.captureStackTrace((ThrowableUtils.NativeError)this.backingJsObject);
                } else {
                    ((ThrowableUtils.NativeError)this.backingJsObject).stack = new ThrowableUtils.NativeError().stack;
                }
            }
            this.stackTrace = null;
        }
        return this;
    }

    @JsMethod
    public Throwable getCause() {
        return this.cause;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public String getMessage() {
        return this.detailMessage;
    }

    public StackTraceElement[] getStackTrace() {
        if (this.stackTrace == null) {
            this.stackTrace = this.constructJavaStackTrace();
        }
        return this.stackTrace;
    }

    private StackTraceElement[] constructJavaStackTrace() {
        ThrowableUtils.JsObject e = this.backingJsObject;
        if (ThrowableUtils.isError(e)) {
            ThrowableUtils.NativeError error = (ThrowableUtils.NativeError)e;
            if (error.stack != null) {
                String[] splitStack = error.stack.split("\n");
                StackTraceElement[] stackTraceElements = new StackTraceElement[splitStack.length];
                for (int i = 0; i < splitStack.length; ++i) {
                    stackTraceElements[i] = new StackTraceElement("", splitStack[i], null, -1);
                }
                return stackTraceElements;
            }
        }
        return new StackTraceElement[0];
    }

    @JsMethod
    public final Throwable[] getSuppressed() {
        return this.suppressedExceptions == null ? new Throwable[]{} : (Throwable[])this.suppressedExceptions.toArray(new Throwable[0]);
    }

    public Throwable initCause(Throwable cause) {
        InternalPreconditions.checkState(this.cause == null, "Can't overwrite cause");
        InternalPreconditions.checkCriticalArgument(cause != this, "Self-causation not permitted");
        this.cause = cause;
        return this;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream out) {
        this.printStackTraceImpl(out, "", "");
    }

    private void printStackTraceImpl(PrintStream out, String prefix, String ident) {
        out.println(ident + prefix + this);
        this.printStackTraceItems(out, ident);
        for (Throwable t : this.getSuppressed()) {
            t.printStackTraceImpl(out, "Suppressed: ", "\t" + ident);
        }
        Throwable theCause = this.getCause();
        if (theCause != null) {
            theCause.printStackTraceImpl(out, "Caused by: ", ident);
        }
    }

    private void printStackTraceItems(PrintStream out, String ident) {
        for (StackTraceElement element : this.getStackTrace()) {
            out.println(ident + "\tat " + element);
        }
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        int length = stackTrace.length;
        StackTraceElement[] copy = new StackTraceElement[length];
        for (int i = 0; i < length; ++i) {
            copy[i] = InternalPreconditions.checkNotNull(stackTrace[i]);
        }
        this.stackTrace = copy;
    }

    public String toString() {
        String className = this.getClass().getName();
        String message = this.getLocalizedMessage();
        return message == null ? className : className + ": " + message;
    }

    @JsMethod
    @Wasm(value="Throwable.of-is-not-supported")
    public static native @JsNonNull Throwable of(Object var0);

    @JsMethod
    public static @JsNonNull Throwable of(ThrowableUtils.JsObject e) {
        Throwable throwable;
        if (e != null && (throwable = ThrowableUtils.getJavaThrowable(e)) != null) {
            return throwable;
        }
        JsException t = ThrowableUtils.isTypeError(e) ? new NullPointerException() : new JsException();
        t.detailMessage = e == null ? "null" : e.toString();
        t.privateInitError(e);
        return t;
    }
}

