/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;
import java.math.BitLevel;

class Multiplication {
    static final BigInteger[] bigFivePows;
    static final BigInteger[] bigTenPows;
    static final int[] fivePows;
    static final int[] tenPows;
    static final int whenUseKaratsuba = 63;

    static BigInteger karatsuba(BigInteger op1, BigInteger op2) {
        if (op2.numberLength > op1.numberLength) {
            BigInteger temp = op1;
            op1 = op2;
            op2 = temp;
        }
        if (op2.numberLength < 63) {
            return Multiplication.multiplyPAP(op1, op2);
        }
        int ndiv2 = (op1.numberLength & 0xFFFFFFFE) << 4;
        BigInteger upperOp1 = op1.shiftRight(ndiv2);
        BigInteger upperOp2 = op2.shiftRight(ndiv2);
        BigInteger lowerOp1 = op1.subtract(upperOp1.shiftLeft(ndiv2));
        BigInteger lowerOp2 = op2.subtract(upperOp2.shiftLeft(ndiv2));
        BigInteger upper = Multiplication.karatsuba(upperOp1, upperOp2);
        BigInteger lower = Multiplication.karatsuba(lowerOp1, lowerOp2);
        BigInteger middle = Multiplication.karatsuba(upperOp1.subtract(lowerOp1), lowerOp2.subtract(upperOp2));
        middle = middle.add(upper).add(lower);
        middle = middle.shiftLeft(ndiv2);
        upper = upper.shiftLeft(ndiv2 << 1);
        return upper.add(middle).add(lower);
    }

    static void multArraysPAP(int[] aDigits, int aLen, int[] bDigits, int bLen, int[] resDigits) {
        if (aLen == 0 || bLen == 0) {
            return;
        }
        if (aLen == 1) {
            resDigits[bLen] = Multiplication.multiplyByInt(resDigits, bDigits, bLen, aDigits[0]);
        } else if (bLen == 1) {
            resDigits[aLen] = Multiplication.multiplyByInt(resDigits, aDigits, aLen, bDigits[0]);
        } else {
            Multiplication.multPAP(aDigits, bDigits, resDigits, aLen, bLen);
        }
    }

    static BigInteger multiply(BigInteger x, BigInteger y) {
        return Multiplication.karatsuba(x, y);
    }

    static BigInteger multiplyByFivePow(BigInteger val, int exp) {
        if (exp < fivePows.length) {
            return Multiplication.multiplyByPositiveInt(val, fivePows[exp]);
        }
        if (exp < bigFivePows.length) {
            return val.multiply(bigFivePows[exp]);
        }
        return val.multiply(bigFivePows[1].pow(exp));
    }

    static int multiplyByInt(int[] a, int aSize, int factor) {
        return Multiplication.multiplyByInt(a, a, aSize, factor);
    }

    static BigInteger multiplyByPositiveInt(BigInteger val, int factor) {
        int resSign = val.sign;
        if (resSign == 0) {
            return BigInteger.ZERO;
        }
        int aNumberLength = val.numberLength;
        int[] aDigits = val.digits;
        if (aNumberLength == 1) {
            long res = Multiplication.unsignedMultAddAdd(aDigits[0], factor, 0, 0);
            int resLo = (int)res;
            int resHi = (int)(res >>> 32);
            return resHi == 0 ? new BigInteger(resSign, resLo) : new BigInteger(resSign, 2, new int[]{resLo, resHi});
        }
        int resLength = aNumberLength + 1;
        int[] resDigits = new int[resLength];
        resDigits[aNumberLength] = Multiplication.multiplyByInt(resDigits, aDigits, aNumberLength, factor);
        BigInteger result = new BigInteger(resSign, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static BigInteger multiplyByTenPow(BigInteger val, int exp) {
        return exp < tenPows.length ? Multiplication.multiplyByPositiveInt(val, tenPows[exp]) : val.multiply(Multiplication.powerOf10(exp));
    }

    static BigInteger multiplyPAP(BigInteger a, BigInteger b) {
        int resSign;
        int aLen = a.numberLength;
        int bLen = b.numberLength;
        int resLength = aLen + bLen;
        int n = resSign = a.sign != b.sign ? -1 : 1;
        if (resLength == 2) {
            long val = Multiplication.unsignedMultAddAdd(a.digits[0], b.digits[0], 0, 0);
            int valueLo = (int)val;
            int valueHi = (int)(val >>> 32);
            return valueHi == 0 ? new BigInteger(resSign, valueLo) : new BigInteger(resSign, 2, new int[]{valueLo, valueHi});
        }
        int[] aDigits = a.digits;
        int[] bDigits = b.digits;
        int[] resDigits = new int[resLength];
        Multiplication.multArraysPAP(aDigits, aLen, bDigits, bLen, resDigits);
        BigInteger result = new BigInteger(resSign, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static void multPAP(int[] a, int[] b, int[] t, int aLen, int bLen) {
        if (a == b && aLen == bLen) {
            Multiplication.square(a, aLen, t);
            return;
        }
        for (int i = 0; i < aLen; ++i) {
            long carry = 0L;
            int aI = a[i];
            for (int j = 0; j < bLen; ++j) {
                carry = Multiplication.unsignedMultAddAdd(aI, b[j], t[i + j], (int)carry);
                t[i + j] = (int)carry;
                carry >>>= 32;
            }
            t[i + bLen] = (int)carry;
        }
    }

    static BigInteger pow(BigInteger base, int exponent) {
        BigInteger res = BigInteger.ONE;
        BigInteger acc = base;
        while (exponent > 1) {
            if ((exponent & 1) != 0) {
                res = res.multiply(acc);
            }
            acc = acc.numberLength == 1 ? acc.multiply(acc) : new BigInteger(1, Multiplication.square(acc.digits, acc.numberLength, new int[acc.numberLength << 1]));
            exponent >>= 1;
        }
        res = res.multiply(acc);
        return res;
    }

    static BigInteger powerOf10(double exp) {
        long longExp;
        BigInteger powerOfFive;
        int intExp = (int)exp;
        if (exp < (double)bigTenPows.length) {
            return bigTenPows[intExp];
        }
        if (exp <= 50.0) {
            return BigInteger.TEN.pow(intExp);
        }
        if (exp <= 1000.0) {
            return bigFivePows[1].pow(intExp).shiftLeft(intExp);
        }
        if (exp > 1000000.0) {
            throw new ArithmeticException("power of ten too big");
        }
        if (exp <= 2.147483647E9) {
            return bigFivePows[1].pow(intExp).shiftLeft(intExp);
        }
        BigInteger res = powerOfFive = bigFivePows[1].pow(Integer.MAX_VALUE);
        intExp = (int)(exp % 2.147483647E9);
        for (longExp = (long)(exp - 2.147483647E9); longExp > Integer.MAX_VALUE; longExp -= Integer.MAX_VALUE) {
            res = res.multiply(powerOfFive);
        }
        res = res.multiply(bigFivePows[1].pow(intExp));
        res = res.shiftLeft(Integer.MAX_VALUE);
        for (longExp = (long)(exp - 2.147483647E9); longExp > Integer.MAX_VALUE; longExp -= Integer.MAX_VALUE) {
            res = res.shiftLeft(Integer.MAX_VALUE);
        }
        res = res.shiftLeft(intExp);
        return res;
    }

    static int[] square(int[] a, int aLen, int[] res) {
        long carry;
        int i;
        for (i = 0; i < aLen; ++i) {
            carry = 0L;
            for (int j = i + 1; j < aLen; ++j) {
                carry = Multiplication.unsignedMultAddAdd(a[i], a[j], res[i + j], (int)carry);
                res[i + j] = (int)carry;
                carry >>>= 32;
            }
            res[i + aLen] = (int)carry;
        }
        BitLevel.shiftLeftOneBit(res, res, aLen << 1);
        carry = 0L;
        i = 0;
        int index = 0;
        while (i < aLen) {
            carry = Multiplication.unsignedMultAddAdd(a[i], a[i], res[index], (int)carry);
            res[index] = (int)carry;
            carry >>>= 32;
            res[index] = (int)(carry += (long)res[++index] & 0xFFFFFFFFL);
            carry >>>= 32;
            ++i;
            ++index;
        }
        return res;
    }

    static long unsignedMultAddAdd(int a, int b, int c, int d) {
        return ((long)a & 0xFFFFFFFFL) * ((long)b & 0xFFFFFFFFL) + ((long)c & 0xFFFFFFFFL) + ((long)d & 0xFFFFFFFFL);
    }

    private static int multiplyByInt(int[] res, int[] a, int aSize, int factor) {
        long carry = 0L;
        for (int i = 0; i < aSize; ++i) {
            carry = Multiplication.unsignedMultAddAdd(a[i], factor, (int)carry, 0);
            res[i] = (int)carry;
            carry >>>= 32;
        }
        return (int)carry;
    }

    private Multiplication() {
    }

    static {
        int i;
        bigFivePows = new BigInteger[32];
        bigTenPows = new BigInteger[32];
        fivePows = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
        tenPows = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
        long fivePow = 1L;
        for (i = 0; i <= 18; ++i) {
            Multiplication.bigFivePows[i] = BigInteger.valueOf(fivePow);
            Multiplication.bigTenPows[i] = BigInteger.valueOf(fivePow << i);
            fivePow *= 5L;
        }
        while (i < bigTenPows.length) {
            Multiplication.bigFivePows[i] = bigFivePows[i - 1].multiply(bigFivePows[1]);
            Multiplication.bigTenPows[i] = bigTenPows[i - 1].multiply(BigInteger.TEN);
            ++i;
        }
    }
}

